/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.wastebasket;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.nexus.proxy.wastebasket.Wastebasket;
import org.sonatype.nexus.rest.AbstractNexusPlexusResource;
import org.sonatype.nexus.rest.model.WastebasketResource;
import org.sonatype.nexus.rest.model.WastebasketResourceResponse;
import org.sonatype.nexus.scheduling.NexusScheduler;
import org.sonatype.nexus.scheduling.NexusTask;
import org.sonatype.nexus.tasks.EmptyTrashTask;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;

@Named
@Singleton
@Path(value="/wastebasket")
@Produces(value={"application/xml", "application/json"})
public class WastebasketPlexusResource
extends AbstractNexusPlexusResource {
    public static final String RESOURCE_URI = "/wastebasket";
    private final Wastebasket wastebasket;
    private final NexusScheduler nexusScheduler;

    @Inject
    public WastebasketPlexusResource(Wastebasket wastebasket, NexusScheduler nexusScheduler) {
        this.wastebasket = wastebasket;
        this.nexusScheduler = nexusScheduler;
    }

    public Object getPayloadInstance() {
        return null;
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/wastebasket**", "authcBasic,perms[nexus:wastebasket]");
    }

    @GET
    @ResourceMethodSignature(output=WastebasketResourceResponse.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        WastebasketResourceResponse result = new WastebasketResourceResponse();
        WastebasketResource resource = new WastebasketResource();
        resource.setItemCount(-1L);
        Long totalSize = this.wastebasket.getTotalSize();
        if (totalSize != null) {
            resource.setSize(totalSize.longValue());
        } else {
            resource.setSize(-1L);
        }
        result.setData(resource);
        return result;
    }

    @DELETE
    @ResourceMethodSignature
    public void delete(Context context, Request request, Response response) throws ResourceException {
        EmptyTrashTask task = (EmptyTrashTask)this.nexusScheduler.createTaskInstance(EmptyTrashTask.class);
        this.nexusScheduler.submit("Internal", (NexusTask)task);
        response.setStatus(Status.SUCCESS_NO_CONTENT);
    }

    public boolean isModifiable() {
        return true;
    }
}

