/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.user;

import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.nexus.rest.model.UserAccount;
import org.sonatype.nexus.rest.model.UserAccountRequestResponseWrapper;
import org.sonatype.nexus.rest.user.AbstractUserAccountPlexusResource;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResourceException;
import org.sonatype.plexus.rest.resource.error.ErrorResponse;
import org.sonatype.security.authorization.AuthorizationException;
import org.sonatype.security.usermanagement.NoSuchUserManagerException;
import org.sonatype.security.usermanagement.User;
import org.sonatype.security.usermanagement.UserNotFoundException;

@Named
@Singleton
@Path(value="/user_account/{accountId}")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
public class UserAccountPlexusResource
extends AbstractUserAccountPlexusResource {
    public static final String ACCOUNT_ID_KEY = "accountId";

    public UserAccountPlexusResource() {
        this.setReadable(true);
        this.setModifiable(true);
    }

    public Object getPayloadInstance() {
        return new UserAccountRequestResponseWrapper();
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/user_account/*", "authcBasic");
    }

    public String getResourceUri() {
        return "/user_account/{accountId}";
    }

    @GET
    @ResourceMethodSignature(pathParams={@PathParam(value="accountId")}, output=UserAccountRequestResponseWrapper.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        UserAccountRequestResponseWrapper result = new UserAccountRequestResponseWrapper();
        try {
            User user = this.userAccountManager.readAccount(this.getUserId(request));
            result.setData(this.nexusToRestModel(user, request));
        }
        catch (UserNotFoundException e) {
            String msg = "User account '" + this.getUserId(request) + "' not found.";
            this.getLogger().debug(msg, (Throwable)e);
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, msg);
        }
        catch (AuthorizationException e) {
            throw new ResourceException(Status.CLIENT_ERROR_FORBIDDEN, "Not allowed to read account '" + this.getUserId(request) + "'.");
        }
        return result;
    }

    @PUT
    @ResourceMethodSignature(pathParams={@PathParam(value="accountId")}, input=UserAccountRequestResponseWrapper.class, output=UserAccountRequestResponseWrapper.class)
    public Object put(Context context, Request request, Response response, Object payload) throws ResourceException {
        UserAccountRequestResponseWrapper result = new UserAccountRequestResponseWrapper();
        UserAccount dto = ((UserAccountRequestResponseWrapper)payload).getData();
        try {
            User user = this.getSecuritySystem().getUser(this.getUserId(request));
            user.setFirstName(dto.getFirstName());
            user.setLastName(dto.getLastName());
            user.setEmailAddress(dto.getEmail());
            this.userAccountManager.updateAccount(user);
            result.setData(this.nexusToRestModel(user, request));
        }
        catch (InvalidConfigurationException e) {
            this.handleInvalidConfigurationException(e);
            return null;
        }
        catch (UserNotFoundException e) {
            String msg = "User account '" + this.getUserId(request) + "' not found.";
            this.getLogger().debug(msg, (Throwable)e);
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, msg);
        }
        catch (NoSuchUserManagerException e) {
            ErrorResponse errorResponse = this.getErrorResponse("*", e.getMessage());
            throw new PlexusResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Unable to update account '" + dto.getUserId() + "'.", (Object)errorResponse);
        }
        catch (AuthorizationException e) {
            throw new ResourceException(Status.CLIENT_ERROR_FORBIDDEN, "Not allowed to update account '" + dto.getUserId() + "'.");
        }
        return result;
    }

    protected String getUserId(Request request) {
        return request.getAttributes().get(ACCOUNT_ID_KEY).toString();
    }
}

