/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.user;

import com.thoughtworks.xstream.XStream;
import javax.inject.Inject;
import org.restlet.data.Request;
import org.sonatype.nexus.rest.model.UserAccount;
import org.sonatype.nexus.rest.model.UserAccountRequestResponseWrapper;
import org.sonatype.nexus.user.UserAccountManager;
import org.sonatype.security.rest.AbstractSecurityPlexusResource;
import org.sonatype.security.usermanagement.DefaultUser;
import org.sonatype.security.usermanagement.User;
import org.sonatype.security.usermanagement.UserStatus;

public abstract class AbstractUserAccountPlexusResource
extends AbstractSecurityPlexusResource {
    protected UserAccountManager userAccountManager;

    @Inject
    public void setUserAccountManager(UserAccountManager userAccountManager) {
        this.userAccountManager = userAccountManager;
    }

    @Override
    public void configureXStream(XStream xstream) {
        super.configureXStream(xstream);
        xstream.processAnnotations(UserAccount.class);
        xstream.processAnnotations(UserAccountRequestResponseWrapper.class);
    }

    protected UserAccount nexusToRestModel(User user, Request request) {
        UserAccount dto = new UserAccount();
        dto.setUserId(user.getUserId());
        dto.setFirstName(user.getFirstName());
        dto.setLastName(user.getLastName());
        dto.setEmail(user.getEmailAddress());
        return dto;
    }

    protected User restToNexusModel(UserAccount dto) {
        DefaultUser user = new DefaultUser();
        user.setUserId(dto.getUserId());
        user.setFirstName(dto.getFirstName());
        user.setLastName(dto.getLastName());
        user.setEmailAddress(dto.getEmail());
        user.setSource("default");
        user.setStatus(UserStatus.active);
        return user;
    }
}

