/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.templates.repositories;

import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.nexus.proxy.maven.AbstractMavenRepositoryConfiguration;
import org.sonatype.nexus.proxy.repository.AbstractShadowRepositoryConfiguration;
import org.sonatype.nexus.proxy.repository.ConfigurableRepository;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.HostedRepository;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.ShadowRepository;
import org.sonatype.nexus.rest.AbstractNexusPlexusResource;
import org.sonatype.nexus.rest.model.RepositoryBaseResource;
import org.sonatype.nexus.rest.model.RepositoryGroupResource;
import org.sonatype.nexus.rest.model.RepositoryProxyResource;
import org.sonatype.nexus.rest.model.RepositoryResource;
import org.sonatype.nexus.rest.model.RepositoryResourceResponse;
import org.sonatype.nexus.rest.model.RepositoryShadowResource;
import org.sonatype.nexus.templates.NoSuchTemplateIdException;
import org.sonatype.nexus.templates.repository.RepositoryTemplate;
import org.sonatype.nexus.templates.repository.maven.AbstractMavenRepositoryTemplate;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;

@Named
@Singleton
@Path(value="/templates/repositories/{repositoryId}")
@Produces(value={"application/xml", "application/json"})
public class RepositoryTemplatePlexusResource
extends AbstractNexusPlexusResource {
    public static final String REPOSITORY_ID_KEY = "repositoryId";
    public static final String RESOURCE_URI = "/templates/repositories/{repositoryId}";

    public Object getPayloadInstance() {
        return new RepositoryResourceResponse();
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/templates/repositories/*", "authcBasic,perms[nexus:repotemplates]");
    }

    protected String getRepositoryId(Request request) {
        return request.getAttributes().get(REPOSITORY_ID_KEY).toString();
    }

    @GET
    @ResourceMethodSignature(pathParams={@PathParam(value="repositoryId")}, output=RepositoryResourceResponse.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        RepositoryResourceResponse result = new RepositoryResourceResponse();
        try {
            RepositoryTemplate template = this.getRepositoryTemplateById(this.getRepositoryId(request));
            RepositoryBaseResource repoRes = null;
            if (ProxyRepository.class.isAssignableFrom(template.getMainFacet())) {
                repoRes = this.createProxy(template);
            } else if (HostedRepository.class.isAssignableFrom(template.getMainFacet())) {
                repoRes = this.createHosted(template);
            } else if (ShadowRepository.class.isAssignableFrom(template.getMainFacet())) {
                repoRes = this.createShadow(template);
            } else if (GroupRepository.class.isAssignableFrom(template.getMainFacet())) {
                repoRes = new RepositoryGroupResource();
                repoRes.setRepoType("group");
            } else {
                throw new ResourceException(Status.SERVER_ERROR_INTERNAL, "Unrecognized repository template with ID='" + template.getId() + "' and mainFacet='" + template.getMainFacet().getName() + "'!");
            }
            repoRes.setId(template.getId());
            repoRes.setName(template.getDescription());
            repoRes.setProvider(template.getRepositoryProviderHint());
            repoRes.setProviderRole(template.getRepositoryProviderRole());
            repoRes.setFormat(template.getContentClass().getId());
            result.setData(repoRes);
        }
        catch (NoSuchTemplateIdException e) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, e.getMessage());
        }
        return result;
    }

    private RepositoryBaseResource createShadow(RepositoryTemplate template) {
        RepositoryShadowResource repoRes = new RepositoryShadowResource();
        repoRes.setRepoType("virtual");
        AbstractShadowRepositoryConfiguration cfg = (AbstractShadowRepositoryConfiguration)template.getConfigurableRepository().getCurrentCoreConfiguration().getExternalConfiguration().getConfiguration(false);
        repoRes.setSyncAtStartup(cfg.isSynchronizeAtStartup());
        repoRes.setShadowOf(cfg.getMasterRepositoryId());
        return repoRes;
    }

    private RepositoryBaseResource createProxy(RepositoryTemplate template) {
        RepositoryProxyResource repoRes = new RepositoryProxyResource();
        repoRes.setRepoType("proxy");
        AbstractMavenRepositoryTemplate m2Template = (AbstractMavenRepositoryTemplate)template;
        repoRes.setRepoPolicy(m2Template.getRepositoryPolicy().name());
        ConfigurableRepository cfg = template.getConfigurableRepository();
        repoRes.setWritePolicy(cfg.getWritePolicy().name());
        repoRes.setBrowseable(cfg.isBrowseable());
        repoRes.setIndexable(cfg.isIndexable());
        repoRes.setExposed(cfg.isExposed());
        repoRes.setNotFoundCacheTTL(cfg.getNotFoundCacheTimeToLive());
        AbstractMavenRepositoryConfiguration repoCfg = (AbstractMavenRepositoryConfiguration)template.getConfigurableRepository().getCurrentCoreConfiguration().getExternalConfiguration().getConfiguration(false);
        repoRes.setChecksumPolicy(repoCfg.getChecksumPolicy().name());
        repoRes.setDownloadRemoteIndexes(repoCfg.isDownloadRemoteIndex());
        repoRes.setArtifactMaxAge(repoCfg.getArtifactMaxAge());
        repoRes.setMetadataMaxAge(repoCfg.getMetadataMaxAge());
        repoRes.setItemMaxAge(Integer.valueOf(repoCfg.getItemMaxAge()));
        repoRes.setFileTypeValidation(repoCfg.isFileTypeValidation());
        return repoRes;
    }

    private RepositoryBaseResource createHosted(RepositoryTemplate template) {
        RepositoryResource repoRes = new RepositoryResource();
        repoRes.setRepoType("hosted");
        AbstractMavenRepositoryTemplate m2Template = (AbstractMavenRepositoryTemplate)template;
        repoRes.setRepoPolicy(m2Template.getRepositoryPolicy().name());
        ConfigurableRepository cfg = template.getConfigurableRepository();
        repoRes.setWritePolicy(cfg.getWritePolicy().name());
        repoRes.setBrowseable(cfg.isBrowseable());
        repoRes.setIndexable(cfg.isIndexable());
        repoRes.setExposed(cfg.isExposed());
        repoRes.setNotFoundCacheTTL(cfg.getNotFoundCacheTimeToLive());
        return repoRes;
    }
}

