/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.templates.repositories;

import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.nexus.proxy.maven.AbstractMavenRepositoryConfiguration;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.HostedRepository;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.ShadowRepository;
import org.sonatype.nexus.rest.AbstractNexusPlexusResource;
import org.sonatype.nexus.rest.model.RepositoryListResource;
import org.sonatype.nexus.rest.model.RepositoryListResourceResponse;
import org.sonatype.nexus.rest.model.RepositoryResourceResponse;
import org.sonatype.nexus.templates.Template;
import org.sonatype.nexus.templates.TemplateSet;
import org.sonatype.nexus.templates.repository.RepositoryTemplate;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;

@Named
@Singleton
@Path(value="/templates/repositories")
@Produces(value={"application/xml", "application/json"})
public class RepositoryTemplateListPlexusResource
extends AbstractNexusPlexusResource {
    public static final String RESOURCE_URI = "/templates/repositories";

    public Object getPayloadInstance() {
        return new RepositoryResourceResponse();
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor(this.getResourceUri(), "authcBasic,perms[nexus:repotemplates]");
    }

    @GET
    @ResourceMethodSignature(output=RepositoryListResourceResponse.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        RepositoryListResourceResponse result = new RepositoryListResourceResponse();
        TemplateSet repoTemplates = this.getRepositoryTemplates();
        for (Template tmp : repoTemplates) {
            RepositoryTemplate template = (RepositoryTemplate)tmp;
            RepositoryListResource repoRes = new RepositoryListResource();
            repoRes.setResourceURI(this.createChildReference(request, this, template.getId()).toString());
            repoRes.setId(template.getId());
            repoRes.setName(template.getDescription());
            if (ProxyRepository.class.isAssignableFrom(template.getMainFacet())) {
                repoRes.setRepoType("proxy");
            } else if (HostedRepository.class.isAssignableFrom(template.getMainFacet())) {
                repoRes.setRepoType("hosted");
            } else if (ShadowRepository.class.isAssignableFrom(template.getMainFacet())) {
                repoRes.setRepoType("virtual");
            } else if (GroupRepository.class.isAssignableFrom(template.getMainFacet())) {
                repoRes.setRepoType("group");
            } else {
                repoRes.setRepoType(template.getMainFacet().getName());
            }
            if (template.getCoreConfiguration().getExternalConfiguration().getConfiguration(false) instanceof AbstractMavenRepositoryConfiguration) {
                repoRes.setRepoPolicy(((AbstractMavenRepositoryConfiguration)template.getCoreConfiguration().getExternalConfiguration().getConfiguration(false)).getRepositoryPolicy().toString());
            }
            repoRes.setFormat(template.getContentClass().getId());
            repoRes.setUserManaged(template.getConfigurableRepository().isUserManaged());
            repoRes.setExposed(template.getConfigurableRepository().isExposed());
            result.addData(repoRes);
        }
        return result;
    }
}

