/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.status;

import com.yammer.metrics.annotation.Timed;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Form;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.nexus.ApplicationStatusSource;
import org.sonatype.nexus.SystemStatus;
import org.sonatype.nexus.rest.model.NexusAuthenticationClientPermissions;
import org.sonatype.nexus.rest.model.StatusResource;
import org.sonatype.nexus.rest.model.StatusResourceResponse;
import org.sonatype.nexus.web.BaseUrlHolder;
import org.sonatype.plexus.rest.resource.ManagedPlexusResource;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.security.rest.authentication.AbstractUIPermissionCalculatingPlexusResource;
import org.sonatype.security.rest.model.AuthenticationClientPermissions;

@Named(value="StatusPlexusResource")
@Singleton
@Typed(value={ManagedPlexusResource.class})
@Path(value="/status")
@Produces(value={"application/xml", "application/json"})
public class StatusPlexusResource
extends AbstractUIPermissionCalculatingPlexusResource
implements ManagedPlexusResource {
    public static final String RESOURCE_URI = "/status";
    private final ApplicationStatusSource applicationStatusSource;

    @Inject
    public StatusPlexusResource(ApplicationStatusSource applicationStatusSource) {
        this.applicationStatusSource = applicationStatusSource;
    }

    public Object getPayloadInstance() {
        return null;
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor(this.getResourceUri(), "authcBasic,perms[nexus:status]");
    }

    @Timed
    @GET
    @ResourceMethodSignature(queryParams={@QueryParam(value="perms")}, output=StatusResourceResponse.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        SystemStatus status = this.applicationStatusSource.getSystemStatus();
        StatusResource resource = new StatusResource();
        resource.setAppName(status.getAppName());
        resource.setFormattedAppName(status.getFormattedAppName());
        resource.setVersion(status.getVersion());
        resource.setApiVersion(status.getApiVersion());
        resource.setEditionLong(status.getEditionLong());
        resource.setEditionShort(status.getEditionShort());
        resource.setAttributionsURL(status.getAttributionsURL());
        resource.setPurchaseURL(status.getPurchaseURL());
        resource.setUserLicenseURL(status.getUserLicenseURL());
        resource.setState(status.getState().toString());
        resource.setInitializedAt(status.getInitializedAt());
        resource.setStartedAt(status.getStartedAt());
        resource.setLastConfigChange(status.getLastConfigChange());
        resource.setFirstStart(status.isFirstStart());
        resource.setInstanceUpgraded(status.isInstanceUpgraded());
        resource.setConfigurationUpgraded(status.isConfigurationUpgraded());
        resource.setErrorCause(this.spit(status.getErrorCause()));
        Form form = request.getResourceRef().getQueryAsForm();
        if (form.getFirst("perms") != null) {
            resource.setClientPermissions(this.getClientPermissions(request));
        }
        resource.setBaseUrl(BaseUrlHolder.get());
        resource.setLicenseInstalled(status.isLicenseInstalled());
        resource.setLicenseExpired(status.isLicenseExpired());
        resource.setTrialLicense(status.isTrialLicense());
        StatusResourceResponse result = new StatusResourceResponse();
        result.setData(resource);
        return result;
    }

    private NexusAuthenticationClientPermissions getClientPermissions(Request request) throws ResourceException {
        AuthenticationClientPermissions originalClientPermissions = this.getClientPermissionsForCurrentUser(request);
        NexusAuthenticationClientPermissions clientPermissions = new NexusAuthenticationClientPermissions();
        clientPermissions.setLoggedIn(originalClientPermissions.isLoggedIn());
        clientPermissions.setLoggedInUsername(originalClientPermissions.getLoggedInUsername());
        clientPermissions.setLoggedInUserSource(originalClientPermissions.getLoggedInUserSource());
        clientPermissions.setLoggedInUserSource(originalClientPermissions.getLoggedInUserSource());
        clientPermissions.setPermissions(originalClientPermissions.getPermissions());
        return clientPermissions;
    }

    private String spit(Throwable t) {
        if (t == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }
}

