/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.schedules;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.nexus.rest.model.FormFieldResource;
import org.sonatype.nexus.rest.model.ScheduledServiceTypeResource;
import org.sonatype.nexus.rest.model.ScheduledServiceTypeResourceResponse;
import org.sonatype.nexus.rest.schedules.AbstractScheduledServicePlexusResource;
import org.sonatype.nexus.tasks.descriptors.ScheduledTaskDescriptor;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;

@Named
@Singleton
@Path(value="/schedule_types")
@Produces(value={"application/xml", "application/json"})
public class ScheduledServiceTypePlexusResource
extends AbstractScheduledServicePlexusResource {
    public static final String RESOURCE_URI = "/schedule_types";

    public Object getPayloadInstance() {
        return null;
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor(this.getResourceUri(), "authcBasic,perms[nexus:tasktypes]");
    }

    @GET
    @ResourceMethodSignature(output=ScheduledServiceTypeResourceResponse.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        ScheduledServiceTypeResourceResponse result = new ScheduledServiceTypeResourceResponse();
        List taskDescriptors = this.getNexusConfiguration().listScheduledTaskDescriptors();
        for (ScheduledTaskDescriptor taskDescriptor : taskDescriptors) {
            if (!taskDescriptor.isExposed()) continue;
            ScheduledServiceTypeResource type = new ScheduledServiceTypeResource();
            type.setId(taskDescriptor.getId());
            type.setName(taskDescriptor.getName());
            type.setFormFields(this.formFieldToDTO(taskDescriptor.formFields(), FormFieldResource.class));
            result.addData(type);
        }
        this.sortTaskType(result.getData());
        return result;
    }

    private void sortTaskType(List<ScheduledServiceTypeResource> types) {
        Collections.sort(types, new Comparator<ScheduledServiceTypeResource>(){

            @Override
            public int compare(ScheduledServiceTypeResource t1, ScheduledServiceTypeResource t2) {
                return t1.getName().compareTo(t2.getName());
            }
        });
    }
}

