/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.schedules;

import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.nexus.rest.model.ScheduledServiceBaseResource;
import org.sonatype.nexus.rest.model.ScheduledServiceResourceStatus;
import org.sonatype.nexus.rest.model.ScheduledServiceResourceStatusResponse;
import org.sonatype.nexus.rest.schedules.AbstractScheduledServicePlexusResource;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.scheduling.NoSuchTaskException;
import org.sonatype.scheduling.ScheduledTask;
import org.sonatype.scheduling.TaskState;

@Named
@Singleton
@Path(value="/schedule_run/{scheduledServiceId}")
@Produces(value={"application/xml", "application/json"})
public class ScheduledServiceRunPlexusResource
extends AbstractScheduledServicePlexusResource {
    public static final String RESOURCE_URI = "/schedule_run/{scheduledServiceId}";

    public ScheduledServiceRunPlexusResource() {
        this.setModifiable(true);
    }

    public Object getPayloadInstance() {
        return null;
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/schedule_run/*", "authcBasic,perms[nexus:tasksrun]");
    }

    @GET
    @ResourceMethodSignature(pathParams={@PathParam(value="scheduledServiceId")}, output=ScheduledServiceResourceStatusResponse.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        ScheduledServiceResourceStatusResponse result = null;
        String scheduledServiceId = this.getScheduledServiceId(request);
        try {
            ScheduledServiceResourceStatus resourceStatus;
            ScheduledTask task = this.getNexusScheduler().getTaskById(scheduledServiceId);
            task.runNow();
            ScheduledServiceBaseResource resource = this.getServiceRestModel(task);
            if (resource != null) {
                resourceStatus = new ScheduledServiceResourceStatus();
                resourceStatus.setResource(resource);
                resourceStatus.setResourceURI(this.createChildReference(request, this, task.getId()).toString());
                resourceStatus.setStatus(task.getTaskState().toString());
                resourceStatus.setReadableStatus(this.getReadableState(task.getTaskState()));
                resourceStatus.setCreated(task.getScheduledAt() == null ? "n/a" : task.getScheduledAt().toString());
                resourceStatus.setLastRunResult(TaskState.BROKEN.equals((Object)task.getTaskState()) ? "Error" : "Ok");
                resourceStatus.setLastRunTime(task.getLastRun() == null ? "n/a" : task.getLastRun().toString());
                resourceStatus.setNextRunTime(task.getNextRun() == null ? "n/a" : task.getNextRun().toString());
                if (task.getScheduledAt() != null) {
                    resourceStatus.setCreatedInMillis(Long.valueOf(task.getScheduledAt().getTime()));
                }
                if (task.getLastRun() != null) {
                    resourceStatus.setLastRunTimeInMillis(Long.valueOf(task.getLastRun().getTime()));
                }
                if (task.getNextRun() != null) {
                    resourceStatus.setNextRunTimeInMillis(Long.valueOf(task.getNextRun().getTime()));
                }
            } else {
                throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "Invalid schedule id (" + scheduledServiceId + "), can't load task.");
            }
            result = new ScheduledServiceResourceStatusResponse();
            result.setData(resourceStatus);
            return result;
        }
        catch (NoSuchTaskException e) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "There is no task with ID=" + scheduledServiceId);
        }
    }

    @DELETE
    @ResourceMethodSignature(pathParams={@PathParam(value="scheduledServiceId")})
    public void delete(Context context, Request request, Response response) throws ResourceException {
        try {
            this.getNexusScheduler().getTaskById(this.getScheduledServiceId(request)).cancelOnly();
            response.setStatus(Status.SUCCESS_NO_CONTENT);
        }
        catch (NoSuchTaskException e) {
            response.setStatus(Status.CLIENT_ERROR_NOT_FOUND, "Scheduled service not found!");
        }
    }

    protected String getScheduledServiceId(Request request) {
        return request.getAttributes().get("scheduledServiceId").toString();
    }
}

