/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.schedules;

import java.text.ParseException;
import java.util.concurrent.RejectedExecutionException;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.nexus.rest.model.ScheduledServiceBaseResource;
import org.sonatype.nexus.rest.model.ScheduledServicePropertyResource;
import org.sonatype.nexus.rest.model.ScheduledServiceResourceResponse;
import org.sonatype.nexus.rest.model.ScheduledServiceResourceStatus;
import org.sonatype.nexus.rest.model.ScheduledServiceResourceStatusResponse;
import org.sonatype.nexus.rest.schedules.AbstractScheduledServicePlexusResource;
import org.sonatype.nexus.scheduling.TaskUtils;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.scheduling.NoSuchTaskException;
import org.sonatype.scheduling.ScheduledTask;
import org.sonatype.scheduling.TaskState;

@Named
@Singleton
@Path(value="/schedules/{scheduledServiceId}")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
public class ScheduledServicePlexusResource
extends AbstractScheduledServicePlexusResource {
    public static final String SCHEDULED_SERVICE_ID_KEY = "scheduledServiceId";
    public static final String RESOURCE_URI = "/schedules/{scheduledServiceId}";

    public ScheduledServicePlexusResource() {
        this.setModifiable(true);
    }

    public Object getPayloadInstance() {
        return new ScheduledServiceResourceResponse();
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/schedules/*", "authcBasic,perms[nexus:tasks]");
    }

    protected String getScheduledServiceId(Request request) {
        return request.getAttributes().get(SCHEDULED_SERVICE_ID_KEY).toString();
    }

    @GET
    @ResourceMethodSignature(pathParams={@PathParam(value="scheduledServiceId")}, output=ScheduledServiceResourceResponse.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        ScheduledServiceResourceResponse result = new ScheduledServiceResourceResponse();
        try {
            ScheduledTask task = this.getNexusScheduler().getTaskById(this.getScheduledServiceId(request));
            ScheduledServiceBaseResource resource = this.getServiceRestModel(task);
            if (resource == null) {
                throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "Invalid schedule id (" + this.getScheduledServiceId(request) + "), can't load task.");
            }
            result.setData(resource);
        }
        catch (NoSuchTaskException e) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "There is no task with ID=" + this.getScheduledServiceId(request));
        }
        return result;
    }

    @PUT
    @ResourceMethodSignature(pathParams={@PathParam(value="scheduledServiceId")}, input=ScheduledServiceResourceResponse.class, output=ScheduledServiceResourceStatusResponse.class)
    public Object put(Context context, Request request, Response response, Object payload) throws ResourceException {
        ScheduledServiceResourceResponse serviceRequest = (ScheduledServiceResourceResponse)payload;
        ScheduledServiceResourceStatusResponse result = null;
        if (serviceRequest != null) {
            ScheduledServiceBaseResource resource = serviceRequest.getData();
            try {
                ScheduledTask task = this.getNexusScheduler().getTaskById(this.getScheduledServiceId(request));
                TaskState state = task.getTaskState();
                if (TaskState.RUNNING.equals((Object)state) || TaskState.CANCELLING.equals((Object)state) || TaskState.SLEEPING.equals((Object)state)) {
                    throw new ResourceException(Status.CLIENT_ERROR_CONFLICT, "Task can't be edited while it is being executed or it is in line to be executed");
                }
                task.setEnabled(resource.isEnabled());
                task.setName(this.getModelName(resource));
                task.setSchedule(this.getModelSchedule(resource));
                for (ScheduledServicePropertyResource prop : resource.getProperties()) {
                    task.getTaskParams().put(prop.getKey(), prop.getValue());
                }
                TaskUtils.setAlertEmail((ScheduledTask)task, (String)resource.getAlertEmail());
                TaskUtils.setId((ScheduledTask)task, (String)resource.getId());
                TaskUtils.setName((ScheduledTask)task, (String)resource.getName());
                task.reset();
                this.getNexusScheduler().updateSchedule(task);
                ScheduledServiceResourceStatus resourceStatus = new ScheduledServiceResourceStatus();
                resourceStatus.setResource(resource);
                resourceStatus.getResource().setId(task.getId());
                resourceStatus.setResourceURI(this.createChildReference(request, this, task.getId()).toString());
                resourceStatus.setStatus(task.getTaskState().toString());
                resourceStatus.setReadableStatus(this.getReadableState(task.getTaskState()));
                resourceStatus.setCreated(task.getScheduledAt() == null ? "n/a" : task.getScheduledAt().toString());
                resourceStatus.setLastRunResult(this.getLastRunResult(task));
                resourceStatus.setLastRunTime(task.getLastRun() == null ? "n/a" : task.getLastRun().toString());
                resourceStatus.setNextRunTime(task.getNextRun() == null ? "n/a" : task.getNextRun().toString());
                if (task.getScheduledAt() != null) {
                    resourceStatus.setCreatedInMillis(Long.valueOf(task.getScheduledAt().getTime()));
                }
                if (task.getLastRun() != null) {
                    resourceStatus.setLastRunTimeInMillis(Long.valueOf(task.getLastRun().getTime()));
                }
                if (task.getNextRun() != null) {
                    resourceStatus.setNextRunTimeInMillis(Long.valueOf(task.getNextRun().getTime()));
                }
                result = new ScheduledServiceResourceStatusResponse();
                result.setData(resourceStatus);
            }
            catch (NoSuchTaskException e) {
                this.getLogger().warn("Unable to locate task id:" + resource.getId(), (Throwable)e);
                throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "Scheduled service not found!");
            }
            catch (RejectedExecutionException e) {
                throw new ResourceException(Status.CLIENT_ERROR_CONFLICT, e.getMessage());
            }
            catch (ParseException e) {
                throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, e.getMessage());
            }
            catch (InvalidConfigurationException e) {
                this.handleConfigurationException((ConfigurationException)((Object)e));
            }
        }
        return result;
    }

    @DELETE
    @ResourceMethodSignature(pathParams={@PathParam(value="scheduledServiceId")})
    public void delete(Context context, Request request, Response response) throws ResourceException {
        try {
            this.getNexusScheduler().getTaskById(this.getScheduledServiceId(request)).cancel();
            response.setStatus(Status.SUCCESS_NO_CONTENT);
        }
        catch (NoSuchTaskException e) {
            response.setStatus(Status.CLIENT_ERROR_NOT_FOUND, "Scheduled service not found!");
        }
    }
}

