/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.schedules;

import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Form;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.nexus.rest.model.ScheduledServiceBaseResource;
import org.sonatype.nexus.rest.model.ScheduledServiceListResource;
import org.sonatype.nexus.rest.model.ScheduledServiceListResourceResponse;
import org.sonatype.nexus.rest.model.ScheduledServiceResourceResponse;
import org.sonatype.nexus.rest.model.ScheduledServiceResourceStatus;
import org.sonatype.nexus.rest.model.ScheduledServiceResourceStatusResponse;
import org.sonatype.nexus.rest.schedules.AbstractScheduledServicePlexusResource;
import org.sonatype.nexus.scheduling.NexusTask;
import org.sonatype.nexus.tasks.descriptors.ScheduledTaskDescriptor;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResourceException;
import org.sonatype.scheduling.ScheduledTask;
import org.sonatype.scheduling.SchedulerTask;
import org.sonatype.scheduling.TaskState;
import org.sonatype.scheduling.schedules.ManualRunSchedule;
import org.sonatype.scheduling.schedules.Schedule;

@Named
@Singleton
@Path(value="/schedules")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
public class ScheduledServiceListPlexusResource
extends AbstractScheduledServicePlexusResource {
    public static final String RESOURCE_URI = "/schedules";
    private static final Long UNKNOWN = null;

    public ScheduledServiceListPlexusResource() {
        this.setModifiable(true);
    }

    public Object getPayloadInstance() {
        return new ScheduledServiceResourceResponse();
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor(this.getResourceUri(), "authcBasic,perms[nexus:tasks]");
    }

    private boolean isAllTasks(Request request) {
        String result;
        Form form = request.getResourceRef().getQueryAsForm();
        if (form != null && (result = form.getFirstValue("allTasks")) != null) {
            return result.equalsIgnoreCase("true");
        }
        return false;
    }

    @GET
    @ResourceMethodSignature(output=ScheduledServiceListResourceResponse.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        boolean allTasks = this.isAllTasks(request);
        Map tasksMap = this.getNexusScheduler().getAllTasks();
        ScheduledServiceListResourceResponse result = new ScheduledServiceListResourceResponse();
        for (String key : tasksMap.keySet()) {
            List tasks = (List)tasksMap.get(key);
            for (ScheduledTask task : tasks) {
                boolean isExposed = true;
                SchedulerTask st = task.getSchedulerTask();
                if (st != null && st instanceof NexusTask) {
                    isExposed = ((NexusTask)st).isExposed();
                }
                if (!allTasks && !isExposed) continue;
                ScheduledServiceListResource item = new ScheduledServiceListResource();
                item.setResourceURI(this.createChildReference(request, this, task.getId()).toString());
                item.setLastRunResult(this.getLastRunResult(task));
                item.setId(task.getId());
                item.setName(task.getName());
                item.setStatus(task.getTaskState().toString());
                item.setReadableStatus(this.getReadableState(task.getTaskState()));
                item.setTypeId(task.getType());
                ScheduledTaskDescriptor descriptor = this.getNexusConfiguration().getScheduledTaskDescriptor(task.getType());
                if (descriptor != null) {
                    item.setTypeName(descriptor.getName());
                }
                item.setCreated(task.getScheduledAt() == null ? "n/a" : task.getScheduledAt().toString());
                item.setLastRunTime(task.getLastRun() == null ? "n/a" : task.getLastRun().toString());
                Date nextRunTime = this.getNextRunTime(task);
                item.setNextRunTime(nextRunTime == null ? "n/a" : nextRunTime.toString());
                if (task.getScheduledAt() != null) {
                    item.setCreatedInMillis(Long.valueOf(task.getScheduledAt().getTime()));
                }
                if (task.getLastRun() != null) {
                    item.setLastRunTimeInMillis(Long.valueOf(task.getLastRun().getTime()));
                }
                if (nextRunTime != null) {
                    item.setNextRunTimeInMillis(Long.valueOf(nextRunTime.getTime()));
                }
                item.setSchedule(this.getScheduleShortName(task.getSchedule()));
                item.setEnabled(task.isEnabled());
                result.addData(item);
            }
        }
        return result;
    }

    @POST
    @ResourceMethodSignature(input=ScheduledServiceResourceResponse.class, output=ScheduledServiceResourceStatusResponse.class)
    public Object post(Context context, Request request, Response response, Object payload) throws ResourceException {
        ScheduledServiceResourceResponse serviceRequest = (ScheduledServiceResourceResponse)payload;
        ScheduledServiceResourceStatusResponse result = null;
        if (serviceRequest != null) {
            ScheduledServiceBaseResource serviceResource = serviceRequest.getData();
            try {
                Schedule schedule = this.getModelSchedule(serviceRequest.getData());
                ScheduledTask task = null;
                NexusTask<?> nexusTask = this.getModelNexusTask(serviceResource, request);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Creating task with type '" + nexusTask.getClass() + "': " + nexusTask.getName() + " (" + nexusTask.getId() + ")");
                }
                task = schedule != null ? this.getNexusScheduler().schedule(this.getModelName(serviceResource), nexusTask, schedule) : this.getNexusScheduler().schedule(this.getModelName(serviceResource), nexusTask, (Schedule)new ManualRunSchedule());
                task.setEnabled(serviceResource.isEnabled());
                this.getNexusScheduler().updateSchedule(task);
                ScheduledServiceResourceStatus resourceStatus = new ScheduledServiceResourceStatus();
                resourceStatus.setResource(serviceResource);
                resourceStatus.getResource().setId(task.getId());
                resourceStatus.setResourceURI(this.createChildReference(request, this, task.getId()).toString());
                resourceStatus.setStatus(task.getTaskState().toString());
                resourceStatus.setReadableStatus(this.getReadableState(task.getTaskState()));
                resourceStatus.setCreated(task.getScheduledAt() == null ? "n/a" : task.getScheduledAt().toString());
                resourceStatus.setLastRunResult(TaskState.BROKEN.equals((Object)task.getTaskState()) ? "Error" : "Ok");
                resourceStatus.setLastRunTime(task.getLastRun() == null ? "n/a" : task.getLastRun().toString());
                resourceStatus.setNextRunTime(task.getNextRun() == null ? "n/a" : task.getNextRun().toString());
                if (task.getScheduledAt() != null) {
                    resourceStatus.setCreatedInMillis(Long.valueOf(task.getScheduledAt().getTime()));
                }
                if (task.getLastRun() != null) {
                    resourceStatus.setLastRunTimeInMillis(Long.valueOf(task.getLastRun().getTime()));
                }
                if (task.getNextRun() != null) {
                    resourceStatus.setNextRunTimeInMillis(Long.valueOf(task.getNextRun().getTime()));
                }
                result = new ScheduledServiceResourceStatusResponse();
                result.setData(resourceStatus);
            }
            catch (RejectedExecutionException e) {
                this.getLogger().warn("Execution of task " + this.getModelName(serviceResource) + " rejected.");
                throw new ResourceException(Status.CLIENT_ERROR_CONFLICT, e.getMessage());
            }
            catch (ParseException e) {
                this.getLogger().warn("Unable to parse data for task " + this.getModelName(serviceResource));
                throw new PlexusResourceException(Status.CLIENT_ERROR_BAD_REQUEST, e.getMessage(), (Object)this.getNexusErrorResponse("cronCommand", e.getMessage()));
            }
            catch (InvalidConfigurationException e) {
                this.handleConfigurationException((ConfigurationException)((Object)e));
            }
        }
        return result;
    }
}

