/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.schedules;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.restlet.data.Request;
import org.restlet.resource.ResourceException;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.configuration.validation.ValidationMessage;
import org.sonatype.configuration.validation.ValidationResponse;
import org.sonatype.nexus.configuration.validator.ApplicationValidationResponse;
import org.sonatype.nexus.rest.formfield.AbstractFormFieldResource;
import org.sonatype.nexus.rest.model.ScheduledServiceAdvancedResource;
import org.sonatype.nexus.rest.model.ScheduledServiceBaseResource;
import org.sonatype.nexus.rest.model.ScheduledServiceDailyResource;
import org.sonatype.nexus.rest.model.ScheduledServiceHourlyResource;
import org.sonatype.nexus.rest.model.ScheduledServiceMonthlyResource;
import org.sonatype.nexus.rest.model.ScheduledServiceOnceResource;
import org.sonatype.nexus.rest.model.ScheduledServicePropertyResource;
import org.sonatype.nexus.rest.model.ScheduledServiceWeeklyResource;
import org.sonatype.nexus.scheduling.NexusScheduler;
import org.sonatype.nexus.scheduling.NexusTask;
import org.sonatype.nexus.scheduling.TaskUtils;
import org.sonatype.scheduling.ScheduledTask;
import org.sonatype.scheduling.SchedulerTask;
import org.sonatype.scheduling.TaskState;
import org.sonatype.scheduling.iterators.MonthlySchedulerIterator;
import org.sonatype.scheduling.schedules.CronSchedule;
import org.sonatype.scheduling.schedules.DailySchedule;
import org.sonatype.scheduling.schedules.HourlySchedule;
import org.sonatype.scheduling.schedules.ManualRunSchedule;
import org.sonatype.scheduling.schedules.MonthlySchedule;
import org.sonatype.scheduling.schedules.OnceSchedule;
import org.sonatype.scheduling.schedules.RunNowSchedule;
import org.sonatype.scheduling.schedules.Schedule;
import org.sonatype.scheduling.schedules.WeeklySchedule;

public abstract class AbstractScheduledServicePlexusResource
extends AbstractFormFieldResource {
    private NexusScheduler nexusScheduler;
    public static final String SCHEDULED_SERVICE_ID_KEY = "scheduledServiceId";
    private DateFormat timeFormat = new SimpleDateFormat("HH:mm");

    @Inject
    public void setNexusScheduler(NexusScheduler nexusScheduler) {
        this.nexusScheduler = nexusScheduler;
    }

    protected NexusScheduler getNexusScheduler() {
        return this.nexusScheduler;
    }

    protected String getScheduleShortName(Schedule schedule) {
        if (ManualRunSchedule.class.isAssignableFrom(schedule.getClass())) {
            return "manual";
        }
        if (RunNowSchedule.class.isAssignableFrom(schedule.getClass())) {
            return "internal";
        }
        if (OnceSchedule.class.isAssignableFrom(schedule.getClass())) {
            return "once";
        }
        if (HourlySchedule.class.isAssignableFrom(schedule.getClass())) {
            return "hourly";
        }
        if (DailySchedule.class.isAssignableFrom(schedule.getClass())) {
            return "daily";
        }
        if (WeeklySchedule.class.isAssignableFrom(schedule.getClass())) {
            return "weekly";
        }
        if (MonthlySchedule.class.isAssignableFrom(schedule.getClass())) {
            return "monthly";
        }
        if (CronSchedule.class.isAssignableFrom(schedule.getClass())) {
            return "advanced";
        }
        return schedule.getClass().getName();
    }

    protected String formatDate(Date date) {
        return Long.toString(date.getTime());
    }

    protected String formatTime(Date date) {
        return this.timeFormat.format(date);
    }

    protected List<ScheduledServicePropertyResource> formatServiceProperties(Map<String, String> map) {
        ArrayList<ScheduledServicePropertyResource> list = new ArrayList<ScheduledServicePropertyResource>();
        for (String key : map.keySet()) {
            if (TaskUtils.isPrivateProperty((String)key)) continue;
            ScheduledServicePropertyResource prop = new ScheduledServicePropertyResource();
            prop.setKey(key);
            prop.setValue(map.get(key));
            list.add(prop);
        }
        return list;
    }

    protected List<String> formatRecurringDayOfWeek(Set<Integer> days) {
        ArrayList<String> list = new ArrayList<String>();
        for (Integer day : days) {
            switch (day) {
                case 1: {
                    list.add("sunday");
                    break;
                }
                case 2: {
                    list.add("monday");
                    break;
                }
                case 3: {
                    list.add("tuesday");
                    break;
                }
                case 4: {
                    list.add("wednesday");
                    break;
                }
                case 5: {
                    list.add("thursday");
                    break;
                }
                case 6: {
                    list.add("friday");
                    break;
                }
                case 7: {
                    list.add("saturday");
                }
            }
        }
        return list;
    }

    protected Set<Integer> formatRecurringDayOfWeek(List<String> days) {
        HashSet<Integer> set = new HashSet<Integer>();
        for (String day : days) {
            if ("sunday".equals(day)) {
                set.add(new Integer(1));
                continue;
            }
            if ("monday".equals(day)) {
                set.add(new Integer(2));
                continue;
            }
            if ("tuesday".equals(day)) {
                set.add(new Integer(3));
                continue;
            }
            if ("wednesday".equals(day)) {
                set.add(new Integer(4));
                continue;
            }
            if ("thursday".equals(day)) {
                set.add(new Integer(5));
                continue;
            }
            if ("friday".equals(day)) {
                set.add(new Integer(6));
                continue;
            }
            if (!"saturday".equals(day)) continue;
            set.add(new Integer(7));
        }
        return set;
    }

    protected List<String> formatRecurringDayOfMonth(Set<Integer> days) {
        ArrayList<String> list = new ArrayList<String>();
        for (Integer day : days) {
            if (MonthlySchedulerIterator.LAST_DAY_OF_MONTH.equals(day)) {
                list.add("last");
                continue;
            }
            list.add(String.valueOf(day));
        }
        return list;
    }

    protected Set<Integer> formatRecurringDayOfMonth(List<String> days) {
        HashSet<Integer> set = new HashSet<Integer>();
        for (String day : days) {
            if ("last".equals(day)) {
                set.add(MonthlySchedulerIterator.LAST_DAY_OF_MONTH);
                continue;
            }
            set.add(Integer.valueOf(day));
        }
        return set;
    }

    protected Date parseDate(String date, String time) {
        Calendar cal = Calendar.getInstance();
        Calendar timeCalendar = Calendar.getInstance();
        try {
            timeCalendar.setTime(this.timeFormat.parse(time));
            cal.setTime(new Date(Long.parseLong(date)));
            cal.add(11, timeCalendar.get(11));
            cal.add(12, timeCalendar.get(12));
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Parsed date from task creation request: " + cal.getTime());
            }
        }
        catch (ParseException e) {
            cal = null;
        }
        return cal == null ? null : cal.getTime();
    }

    public String getModelName(ScheduledServiceBaseResource model) {
        return model.getName();
    }

    public NexusTask<?> getModelNexusTask(ScheduledServiceBaseResource model, Request request) throws IllegalArgumentException, ResourceException {
        String serviceType = model.getTypeId();
        NexusTask task = this.getNexusScheduler().createTaskInstance(serviceType);
        for (ScheduledServicePropertyResource prop : model.getProperties()) {
            task.addParameter(prop.getKey(), prop.getValue());
        }
        TaskUtils.setAlertEmail((SchedulerTask)task, (String)model.getAlertEmail());
        TaskUtils.setId((SchedulerTask)task, (String)model.getId());
        TaskUtils.setName((SchedulerTask)task, (String)model.getName());
        return task;
    }

    public void validateStartDate(String date) throws InvalidConfigurationException {
        Calendar cal = Calendar.getInstance();
        Date startDate = new Date(Long.parseLong(date));
        cal.setTime(startDate);
        Calendar nowCal = Calendar.getInstance();
        nowCal.add(6, -1);
        nowCal.set(10, 0);
        nowCal.set(12, 0);
        nowCal.set(13, 0);
        nowCal.set(14, 0);
        if (cal.before(nowCal)) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Validation error for startDate: " + startDate.toString());
            }
            ApplicationValidationResponse vr = new ApplicationValidationResponse();
            ValidationMessage vm = new ValidationMessage("startDate", "Date cannot be in the past.");
            vr.addValidationError(vm);
            throw new InvalidConfigurationException((ValidationResponse)vr);
        }
    }

    public void validateTime(String key, Date date) throws InvalidConfigurationException {
        if (date.before(new Date())) {
            ApplicationValidationResponse vr = new ApplicationValidationResponse();
            ValidationMessage vm = new ValidationMessage(key, "Time cannot be in the past.");
            vr.addValidationError(vm);
            throw new InvalidConfigurationException((ValidationResponse)vr);
        }
    }

    public Schedule getModelSchedule(ScheduledServiceBaseResource model) throws ParseException, InvalidConfigurationException {
        CronSchedule schedule = null;
        if (ScheduledServiceAdvancedResource.class.isAssignableFrom(model.getClass())) {
            schedule = new CronSchedule(((ScheduledServiceAdvancedResource)model).getCronCommand());
        } else if (ScheduledServiceMonthlyResource.class.isAssignableFrom(model.getClass())) {
            Date date = this.parseDate(((ScheduledServiceMonthlyResource)model).getStartDate(), ((ScheduledServiceMonthlyResource)model).getRecurringTime());
            schedule = new MonthlySchedule(date, null, this.formatRecurringDayOfMonth(((ScheduledServiceMonthlyResource)model).getRecurringDay()));
        } else if (ScheduledServiceWeeklyResource.class.isAssignableFrom(model.getClass())) {
            Date date = this.parseDate(((ScheduledServiceWeeklyResource)model).getStartDate(), ((ScheduledServiceWeeklyResource)model).getRecurringTime());
            schedule = new WeeklySchedule(date, null, this.formatRecurringDayOfWeek(((ScheduledServiceWeeklyResource)model).getRecurringDay()));
        } else if (ScheduledServiceDailyResource.class.isAssignableFrom(model.getClass())) {
            Date date = this.parseDate(((ScheduledServiceDailyResource)model).getStartDate(), ((ScheduledServiceDailyResource)model).getRecurringTime());
            schedule = new DailySchedule(date, null);
        } else if (ScheduledServiceHourlyResource.class.isAssignableFrom(model.getClass())) {
            Date date = this.parseDate(((ScheduledServiceHourlyResource)model).getStartDate(), ((ScheduledServiceHourlyResource)model).getStartTime());
            schedule = new HourlySchedule(date, null);
        } else if (ScheduledServiceOnceResource.class.isAssignableFrom(model.getClass())) {
            Date date = this.parseDate(((ScheduledServiceOnceResource)model).getStartDate(), ((ScheduledServiceOnceResource)model).getStartTime());
            this.validateStartDate(((ScheduledServiceOnceResource)model).getStartDate());
            this.validateTime("startTime", date);
            schedule = new OnceSchedule(this.parseDate(((ScheduledServiceOnceResource)model).getStartDate(), ((ScheduledServiceOnceResource)model).getStartTime()));
        } else {
            schedule = new ManualRunSchedule();
        }
        return schedule;
    }

    public <T> ScheduledServiceBaseResource getServiceRestModel(ScheduledTask<T> task) {
        ScheduledServiceBaseResource resource = null;
        if (RunNowSchedule.class.isAssignableFrom(task.getSchedule().getClass()) || ManualRunSchedule.class.isAssignableFrom(task.getSchedule().getClass())) {
            resource = new ScheduledServiceBaseResource();
        } else if (OnceSchedule.class.isAssignableFrom(task.getSchedule().getClass())) {
            resource = new ScheduledServiceOnceResource();
            OnceSchedule taskSchedule = (OnceSchedule)task.getSchedule();
            ScheduledServiceOnceResource res = (ScheduledServiceOnceResource)resource;
            res.setStartDate(this.formatDate(taskSchedule.getStartDate()));
            res.setStartTime(this.formatTime(taskSchedule.getStartDate()));
        } else if (HourlySchedule.class.isAssignableFrom(task.getSchedule().getClass())) {
            resource = new ScheduledServiceHourlyResource();
            HourlySchedule taskSchedule = (HourlySchedule)task.getSchedule();
            ScheduledServiceHourlyResource res = (ScheduledServiceHourlyResource)resource;
            res.setStartDate(this.formatDate(taskSchedule.getStartDate()));
            res.setStartTime(this.formatTime(taskSchedule.getStartDate()));
        } else if (DailySchedule.class.isAssignableFrom(task.getSchedule().getClass())) {
            resource = new ScheduledServiceDailyResource();
            DailySchedule taskSchedule = (DailySchedule)task.getSchedule();
            ScheduledServiceDailyResource res = (ScheduledServiceDailyResource)resource;
            res.setStartDate(this.formatDate(taskSchedule.getStartDate()));
            res.setRecurringTime(this.formatTime(taskSchedule.getStartDate()));
        } else if (WeeklySchedule.class.isAssignableFrom(task.getSchedule().getClass())) {
            resource = new ScheduledServiceWeeklyResource();
            WeeklySchedule taskSchedule = (WeeklySchedule)task.getSchedule();
            ScheduledServiceWeeklyResource res = (ScheduledServiceWeeklyResource)resource;
            res.setStartDate(this.formatDate(taskSchedule.getStartDate()));
            res.setRecurringTime(this.formatTime(taskSchedule.getStartDate()));
            res.setRecurringDay(this.formatRecurringDayOfWeek(taskSchedule.getDaysToRun()));
        } else if (MonthlySchedule.class.isAssignableFrom(task.getSchedule().getClass())) {
            resource = new ScheduledServiceMonthlyResource();
            MonthlySchedule taskSchedule = (MonthlySchedule)task.getSchedule();
            ScheduledServiceMonthlyResource res = (ScheduledServiceMonthlyResource)resource;
            res.setStartDate(this.formatDate(taskSchedule.getStartDate()));
            res.setRecurringTime(this.formatTime(taskSchedule.getStartDate()));
            res.setRecurringDay(this.formatRecurringDayOfMonth(taskSchedule.getDaysToRun()));
        } else if (CronSchedule.class.isAssignableFrom(task.getSchedule().getClass())) {
            resource = new ScheduledServiceAdvancedResource();
            CronSchedule taskSchedule = (CronSchedule)task.getSchedule();
            ScheduledServiceAdvancedResource res = (ScheduledServiceAdvancedResource)resource;
            res.setCronCommand(taskSchedule.getCronString());
        }
        if (resource != null) {
            resource.setId(task.getId());
            resource.setEnabled(task.isEnabled());
            resource.setName(task.getName());
            resource.setSchedule(this.getScheduleShortName(task.getSchedule()));
            resource.setTypeId(task.getType());
            resource.setProperties(this.formatServiceProperties(task.getTaskParams()));
            resource.setAlertEmail(TaskUtils.getAlertEmail(task));
        }
        return resource;
    }

    protected <T> Date getNextRunTime(ScheduledTask<T> task) {
        Date nextRunTime = null;
        if (!task.getSchedule().getClass().isAssignableFrom(RunNowSchedule.class) && task.getNextRun() != null) {
            nextRunTime = task.getNextRun();
        }
        return nextRunTime;
    }

    protected String getLastRunResult(ScheduledTask<?> task) {
        String lastRunResult = "n/a";
        if (task.getLastStatus() != null) {
            String string = lastRunResult = TaskState.BROKEN.equals((Object)task.getLastStatus()) ? "Error" : "Ok";
            if (task.getDuration() != 0L) {
                long milliseconds = task.getDuration();
                int hours = (int)(milliseconds / 1000L / 3600L);
                int minutes = (int)(milliseconds / 1000L / 60L - (long)(hours * 60));
                int seconds = (int)(milliseconds / 1000L % 60L);
                lastRunResult = lastRunResult + " [";
                if (hours != 0) {
                    lastRunResult = lastRunResult + hours;
                    lastRunResult = lastRunResult + "h";
                }
                if (minutes != 0 || hours != 0) {
                    lastRunResult = lastRunResult + minutes;
                    lastRunResult = lastRunResult + "m";
                }
                lastRunResult = lastRunResult + seconds;
                lastRunResult = lastRunResult + "s";
                lastRunResult = lastRunResult + "]";
            }
        }
        return lastRunResult;
    }

    protected String getReadableState(TaskState taskState) {
        switch (taskState) {
            case SUBMITTED: 
            case WAITING: 
            case FINISHED: 
            case BROKEN: {
                return "Waiting";
            }
            case RUNNING: {
                return "Running";
            }
            case SLEEPING: {
                return "Blocked";
            }
            case CANCELLING: {
                return "Cancelling";
            }
            case CANCELLED: {
                return "Cancelled";
            }
        }
        throw new IllegalStateException();
    }
}

