/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.routing;

import com.google.common.base.Strings;
import com.google.common.primitives.Ints;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.nexus.proxy.maven.MavenHostedRepository;
import org.sonatype.nexus.proxy.maven.MavenProxyRepository;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.maven.routing.DiscoveryConfig;
import org.sonatype.nexus.proxy.maven.routing.DiscoveryStatus;
import org.sonatype.nexus.proxy.maven.routing.PublishingStatus;
import org.sonatype.nexus.proxy.maven.routing.RoutingStatus;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.rest.RepositoryURLBuilder;
import org.sonatype.nexus.rest.model.RoutingDiscoveryStatusMessage;
import org.sonatype.nexus.rest.model.RoutingStatusMessage;
import org.sonatype.nexus.rest.model.RoutingStatusMessageWrapper;
import org.sonatype.nexus.rest.routing.RoutingResourceSupport;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;

@Named
@Singleton
@Path(value="/repositories/{repositoryId}/routing")
@Produces(value={"application/xml", "application/json"})
public class RoutingStatusResource
extends RoutingResourceSupport {
    public static final String RESOURCE_URI = "/repositories/{repositoryId}/routing";
    private RepositoryURLBuilder repositoryURLBuilder;

    @Inject
    public void setRepositoryURLBuilder(RepositoryURLBuilder repositoryURLBuilder) {
        this.repositoryURLBuilder = repositoryURLBuilder;
    }

    public Object getPayloadInstance() {
        return new RoutingStatusMessageWrapper();
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/repositories/*/routing", "authcBasic,perms[nexus:repositories]");
    }

    @GET
    @ResourceMethodSignature(pathParams={@PathParam(value="repositoryId")}, output=RoutingStatusMessageWrapper.class)
    public RoutingStatusMessageWrapper get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        MavenRepository mavenRepository = this.getMavenRepository(request, MavenRepository.class);
        RoutingStatus status = this.getManager().getStatusFor(mavenRepository);
        RoutingStatusMessage payload = new RoutingStatusMessage();
        switch (status.getPublishingStatus().getStatus()) {
            case PUBLISHED: {
                payload.setPublishedStatus(1);
                break;
            }
            case NOT_PUBLISHED: {
                payload.setPublishedStatus(-1);
                break;
            }
            default: {
                payload.setPublishedStatus(0);
            }
        }
        payload.setPublishedMessage(status.getPublishingStatus().getLastPublishedMessage());
        PublishingStatus pstatus = status.getPublishingStatus();
        if (PublishingStatus.PStatus.PUBLISHED == pstatus.getStatus()) {
            String repositoryUrl;
            payload.setPublishedTimestamp(pstatus.getLastPublishedTimestamp());
            if (mavenRepository.isExposed() && pstatus.getLastPublishedFilePath() != null && (repositoryUrl = this.repositoryURLBuilder.getExposedRepositoryContentUrl((Repository)mavenRepository)) != null) {
                payload.setPublishedUrl(repositoryUrl + pstatus.getLastPublishedFilePath());
            }
        } else {
            payload.setPublishedTimestamp(-1L);
            payload.setPublishedUrl(null);
        }
        if (DiscoveryStatus.DStatus.NOT_A_PROXY == status.getDiscoveryStatus().getStatus()) {
            payload.setDiscovery(null);
        } else {
            DiscoveryStatus dstatus = status.getDiscoveryStatus();
            RoutingDiscoveryStatusMessage discoveryPayload = new RoutingDiscoveryStatusMessage();
            payload.setDiscovery(discoveryPayload);
            if (DiscoveryStatus.DStatus.DISABLED == status.getDiscoveryStatus().getStatus()) {
                discoveryPayload.setDiscoveryEnabled(false);
                discoveryPayload.setDiscoveryLastStrategy("");
                discoveryPayload.setDiscoveryLastMessage("");
            } else {
                MavenProxyRepository mavenProxyRepository = this.getMavenRepository(request, MavenProxyRepository.class);
                DiscoveryConfig config = this.getManager().getRemoteDiscoveryConfig(mavenProxyRepository);
                discoveryPayload.setDiscoveryEnabled(true);
                discoveryPayload.setDiscoveryIntervalHours(Ints.saturatedCast((long)TimeUnit.MILLISECONDS.toHours(config.getDiscoveryInterval())));
                discoveryPayload.setDiscoveryLastStatus(0);
                discoveryPayload.setDiscoveryLastStrategy("");
                discoveryPayload.setDiscoveryLastMessage("");
                if (DiscoveryStatus.DStatus.ENABLED_IN_PROGRESS.ordinal() < status.getDiscoveryStatus().getStatus().ordinal()) {
                    if (DiscoveryStatus.DStatus.SUCCESSFUL == status.getDiscoveryStatus().getStatus()) {
                        discoveryPayload.setDiscoveryLastStatus(1);
                    } else {
                        discoveryPayload.setDiscoveryLastStatus(-1);
                    }
                    discoveryPayload.setDiscoveryLastStrategy(Strings.nullToEmpty((String)dstatus.getLastDiscoveryStrategy()));
                    discoveryPayload.setDiscoveryLastMessage(Strings.nullToEmpty((String)dstatus.getLastDiscoveryMessage()));
                    discoveryPayload.setDiscoveryLastRunTimestamp(dstatus.getLastDiscoveryTimestamp());
                }
            }
        }
        RoutingStatusMessageWrapper responseNessage = new RoutingStatusMessageWrapper();
        responseNessage.setData(payload);
        return responseNessage;
    }

    @DELETE
    @ResourceMethodSignature(pathParams={@PathParam(value="repositoryId")})
    public void delete(Context context, Request request, Response response) throws ResourceException {
        try {
            MavenProxyRepository mavenRepository = this.getMavenRepository(request, MavenProxyRepository.class);
            this.getManager().updatePrefixFile((MavenRepository)mavenRepository);
            response.setStatus(Status.SUCCESS_ACCEPTED);
        }
        catch (IllegalStateException e) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, e.getMessage(), (Throwable)e);
        }
        catch (ResourceException e) {
            if (Status.CLIENT_ERROR_BAD_REQUEST.getCode() == e.getStatus().getCode()) {
                MavenHostedRepository mavenRepository = this.getMavenRepository(request, MavenHostedRepository.class);
                this.getManager().updatePrefixFile((MavenRepository)mavenRepository);
                response.setStatus(Status.SUCCESS_ACCEPTED);
            }
            throw e;
        }
    }
}

