/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.routing;

import javax.inject.Inject;
import org.restlet.data.Request;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.maven.routing.Manager;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.rest.AbstractNexusPlexusResource;

public abstract class RoutingResourceSupport
extends AbstractNexusPlexusResource {
    protected static final String REPOSITORY_ID_KEY = "repositoryId";
    private Manager manager;

    public RoutingResourceSupport() {
        this.setModifiable(true);
    }

    @Inject
    public void setManager(Manager manager) {
        this.manager = manager;
    }

    protected Manager getManager() {
        return this.manager;
    }

    protected <T extends MavenRepository> T getMavenRepository(Request request, Class<T> clazz) throws ResourceException {
        String repositoryId = request.getAttributes().get(REPOSITORY_ID_KEY).toString();
        try {
            Repository repository = this.getRepositoryRegistry().getRepository(repositoryId);
            MavenRepository mavenRepository = (MavenRepository)repository.adaptToFacet(clazz);
            if (mavenRepository != null) {
                if (!this.getManager().isMavenRepositorySupported(mavenRepository)) {
                    throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Repository with ID=\"" + repositoryId + "\" unsupported!");
                }
                return (T)mavenRepository;
            }
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Repository with ID=\"" + repositoryId + "\" is not a required type of " + clazz.getSimpleName() + ".");
        }
        catch (NoSuchRepositoryException e) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "No repository with ID=\"" + repositoryId + "\" found.", (Throwable)e);
        }
    }
}

