/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.routing;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.nexus.proxy.maven.MavenProxyRepository;
import org.sonatype.nexus.proxy.maven.routing.DiscoveryConfig;
import org.sonatype.nexus.rest.model.RoutingConfigMessage;
import org.sonatype.nexus.rest.model.RoutingConfigMessageWrapper;
import org.sonatype.nexus.rest.routing.RoutingResourceSupport;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;

@Named
@Singleton
@Path(value="/repositories/{repositoryId}/routing/config")
@Produces(value={"application/xml", "application/json"})
public class RoutingConfigResource
extends RoutingResourceSupport {
    public static final String RESOURCE_URI = "/repositories/{repositoryId}/routing/config";

    public Object getPayloadInstance() {
        return new RoutingConfigMessageWrapper();
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/repositories/*/routing/config", "authcBasic,perms[nexus:repositories]");
    }

    @GET
    @ResourceMethodSignature(pathParams={@PathParam(value="repositoryId")}, output=RoutingConfigMessageWrapper.class)
    public RoutingConfigMessageWrapper get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        MavenProxyRepository mavenProxyRepository = this.getMavenRepository(request, MavenProxyRepository.class);
        DiscoveryConfig config = this.getManager().getRemoteDiscoveryConfig(mavenProxyRepository);
        RoutingConfigMessage payload = new RoutingConfigMessage();
        payload.setDiscoveryEnabled(config.isEnabled());
        payload.setDiscoveryIntervalHours(Ints.saturatedCast((long)TimeUnit.MILLISECONDS.toHours(config.getDiscoveryInterval())));
        RoutingConfigMessageWrapper responseNessage = new RoutingConfigMessageWrapper();
        responseNessage.setData(payload);
        return responseNessage;
    }

    @PUT
    @ResourceMethodSignature(pathParams={@PathParam(value="repositoryId")}, input=RoutingConfigMessageWrapper.class, output=RoutingConfigMessageWrapper.class)
    public RoutingConfigMessageWrapper put(Context context, Request request, Response response, Object payload) throws ResourceException {
        try {
            MavenProxyRepository mavenProxyRepository = this.getMavenRepository(request, MavenProxyRepository.class);
            DiscoveryConfig oldConfig = this.getManager().getRemoteDiscoveryConfig(mavenProxyRepository);
            RoutingConfigMessageWrapper wrapper = (RoutingConfigMessageWrapper)RoutingConfigMessageWrapper.class.cast(payload);
            DiscoveryConfig config = new DiscoveryConfig(wrapper.getData().isDiscoveryEnabled(), wrapper.getData().getDiscoveryIntervalHours() > 0 ? TimeUnit.HOURS.toMillis(wrapper.getData().getDiscoveryIntervalHours()) : oldConfig.getDiscoveryInterval());
            this.getManager().setRemoteDiscoveryConfig(mavenProxyRepository, config);
            return wrapper;
        }
        catch (ClassCastException e) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Message not recognized!", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Invalid or illegal configuration!", (Throwable)e);
        }
        catch (IOException e) {
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, (Throwable)e);
        }
    }
}

