/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.routes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.mapping.RepositoryPathMapping;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.rest.NoSuchRepositoryAccessException;
import org.sonatype.nexus.rest.model.RepositoryRouteMemberRepository;
import org.sonatype.nexus.rest.model.RepositoryRouteResource;
import org.sonatype.nexus.rest.model.RepositoryRouteResourceResponse;
import org.sonatype.nexus.rest.routes.AbstractRepositoryRoutePlexusResource;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResourceException;
import org.sonatype.plexus.rest.resource.error.ErrorResponse;

@Named
@Singleton
@Path(value="/repo_routes/{routeId}")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
public class RepositoryRoutePlexusResource
extends AbstractRepositoryRoutePlexusResource {
    public static final String RESOURCE_URI = "/repo_routes/{routeId}";

    public RepositoryRoutePlexusResource() {
        this.setModifiable(true);
    }

    public Object getPayloadInstance() {
        return new RepositoryRouteResourceResponse();
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/repo_routes/*", "authcBasic,perms[nexus:routes]");
    }

    protected String getRouteId(Request request) {
        return request.getAttributes().get("routeId").toString();
    }

    @GET
    @ResourceMethodSignature(pathParams={@PathParam(value="routeId")}, output=RepositoryRouteResourceResponse.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        RepositoryRouteResourceResponse result = null;
        try {
            RepositoryPathMapping route = (RepositoryPathMapping)this.getRepositoryMapper().getMappings().get(this.getRouteId(request));
            if (route == null) {
                throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "No such route");
            }
            RepositoryRouteResource resource = new RepositoryRouteResource();
            resource.setId(this.getRouteId(request));
            if (!route.isAllGroups()) {
                this.getRepositoryRegistry().getRepositoryWithFacet(route.getGroupId(), GroupRepository.class);
            }
            resource.setGroupId(route.getGroupId());
            resource.setRuleType(this.config2resourceType(route.getMappingType()));
            resource.setPattern(((Pattern)route.getPatterns().get(0)).toString());
            resource.setRepositories(this.getRepositoryRouteMemberRepositoryList(request.getResourceRef().getParentRef(), route.getMappedRepositories(), request, route.getId()));
            result = new RepositoryRouteResourceResponse();
            result.setData(resource);
        }
        catch (NoSuchRepositoryAccessException e) {
            this.getLogger().debug("Access Denied to a repository declared within a group!", (Throwable)((Object)e));
            throw new ResourceException(Status.CLIENT_ERROR_FORBIDDEN, (Throwable)((Object)e));
        }
        catch (NoSuchRepositoryException e) {
            this.getLogger().warn("Cannot find a repository declared within a group!", (Throwable)e);
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, (Throwable)e);
        }
        catch (IndexOutOfBoundsException e) {
            this.getLogger().warn("Repository route not found, id=" + this.getRouteId(request));
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "Repository Route Not Found");
        }
        return result;
    }

    @PUT
    @ResourceMethodSignature(pathParams={@PathParam(value="routeId")}, input=RepositoryRouteResourceResponse.class, output=RepositoryRouteResourceResponse.class)
    public Object put(Context context, Request request, Response response, Object payload) throws ResourceException {
        RepositoryRouteResourceResponse routeRequest = (RepositoryRouteResourceResponse)payload;
        Object result = null;
        if (routeRequest != null) {
            RepositoryRouteResource resource = routeRequest.getData();
            if (!"blocking".equals(resource.getRuleType()) && (resource.getRepositories() == null || resource.getRepositories().size() == 0) || resource.getId() == null || !resource.getId().equals(this.getRouteId(request))) {
                throw new PlexusResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "The route cannot have zero repository members!", (Object)this.getNexusErrorResponse("repositories", "The route cannot have zero repository members!"));
            }
            if ("blocking".equals(resource.getRuleType())) {
                resource.setRepositories(null);
            }
            try {
                RepositoryPathMapping route = (RepositoryPathMapping)this.getRepositoryMapper().getMappings().get(this.getRouteId(request));
                if (route == null) {
                    throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "Route not found!");
                }
                ArrayList<String> mappedReposes = new ArrayList<String>(resource.getRepositories().size());
                for (RepositoryRouteMemberRepository member : resource.getRepositories()) {
                    mappedReposes.add(member.getId());
                }
                RepositoryPathMapping newRoute = new RepositoryPathMapping(route.getId(), this.resource2configType(resource.getRuleType()), resource.getGroupId(), Arrays.asList(resource.getPattern()), mappedReposes);
                this.getRepositoryMapper().addMapping(newRoute);
                this.getNexusConfiguration().saveConfiguration();
                response.setStatus(Status.SUCCESS_NO_CONTENT);
            }
            catch (ConfigurationException e) {
                if (e.getCause() != null && e.getCause() instanceof PatternSyntaxException) {
                    throw new PlexusResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Configuration error.", (Object)this.getNexusErrorResponse("pattern", e.getMessage()));
                }
                this.handleConfigurationException(e);
            }
            catch (PatternSyntaxException e) {
                ErrorResponse errorResponse = this.getNexusErrorResponse("*", e.getMessage());
                throw new PlexusResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Configuration error.", (Object)errorResponse);
            }
            catch (IOException e) {
                this.getLogger().warn("Got IO Exception!", (Throwable)e);
                throw new ResourceException(Status.SERVER_ERROR_INTERNAL);
            }
        }
        return result;
    }

    @DELETE
    @ResourceMethodSignature(pathParams={@PathParam(value="routeId")})
    public void delete(Context context, Request request, Response response) throws ResourceException {
        try {
            RepositoryPathMapping route = (RepositoryPathMapping)this.getRepositoryMapper().getMappings().get(this.getRouteId(request));
            if (route == null) {
                throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "Route not found!");
            }
            this.getRepositoryMapper().removeMapping(this.getRouteId(request));
            this.getNexusConfiguration().saveConfiguration();
            response.setStatus(Status.SUCCESS_NO_CONTENT);
        }
        catch (IOException e) {
            this.getLogger().warn("Got IO Exception!", (Throwable)e);
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL);
        }
    }
}

