/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.routes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.mapping.RepositoryPathMapping;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.rest.NoSuchRepositoryAccessException;
import org.sonatype.nexus.rest.model.RepositoryRouteListResource;
import org.sonatype.nexus.rest.model.RepositoryRouteListResourceResponse;
import org.sonatype.nexus.rest.model.RepositoryRouteMemberRepository;
import org.sonatype.nexus.rest.model.RepositoryRouteResource;
import org.sonatype.nexus.rest.model.RepositoryRouteResourceResponse;
import org.sonatype.nexus.rest.routes.AbstractRepositoryRoutePlexusResource;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResourceException;
import org.sonatype.plexus.rest.resource.error.ErrorResponse;

@Named
@Singleton
@Path(value="/repo_routes")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
public class RepositoryRouteListPlexusResource
extends AbstractRepositoryRoutePlexusResource {
    public static final String RESOURCE_URI = "/repo_routes";

    public RepositoryRouteListPlexusResource() {
        this.setModifiable(true);
    }

    public Object getPayloadInstance() {
        return new RepositoryRouteResourceResponse();
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor(this.getResourceUri(), "authcBasic,perms[nexus:routes]");
    }

    @GET
    @ResourceMethodSignature(output=RepositoryRouteListResourceResponse.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        RepositoryRouteListResourceResponse result = new RepositoryRouteListResourceResponse();
        Map mappings = this.getRepositoryMapper().getMappings();
        RepositoryRouteListResource resource = null;
        for (RepositoryPathMapping item : mappings.values()) {
            resource = new RepositoryRouteListResource();
            if (!item.getGroupId().equals("*")) {
                try {
                    this.getRepositoryRegistry().getRepositoryWithFacet(item.getGroupId(), GroupRepository.class);
                }
                catch (NoSuchRepositoryAccessException e) {
                    this.getLogger().debug("Access Denied to Group '" + item.getGroupId() + "' contained within route: + '" + item.getId() + "'!", (Throwable)((Object)e));
                    continue;
                }
                catch (NoSuchRepositoryException e) {
                    this.getLogger().warn("Cannot find group '" + item.getGroupId() + "' declared within route: + '" + item.getId() + "'!", (Throwable)e);
                    continue;
                }
            }
            resource.setGroupId(item.getGroupId());
            resource.setResourceURI(this.createChildReference(request, this, item.getId()).toString());
            resource.setRuleType(this.config2resourceType(item.getMappingType()));
            resource.setPattern(((Pattern)item.getPatterns().get(0)).toString());
            try {
                resource.setRepositories(this.getRepositoryRouteMemberRepositoryList(request.getResourceRef(), item.getMappedRepositories(), request, item.getId()));
            }
            catch (NoSuchRepositoryAccessException e) {
                this.getLogger().debug("Access Denied to Group '" + item.getGroupId() + "' contained within route: + '" + item.getId() + "'!", (Throwable)((Object)e));
                continue;
            }
            result.addData(resource);
        }
        return result;
    }

    @POST
    @ResourceMethodSignature(input=RepositoryRouteResourceResponse.class, output=RepositoryRouteResourceResponse.class)
    public Object post(Context context, Request request, Response response, Object payload) throws ResourceException {
        RepositoryRouteResourceResponse routeRequest = (RepositoryRouteResourceResponse)payload;
        RepositoryRouteResourceResponse result = null;
        if (routeRequest != null) {
            RepositoryRouteResource resource = routeRequest.getData();
            if (!("blocking".equals(resource.getRuleType()) || resource.getRepositories() != null && resource.getRepositories().size() != 0)) {
                throw new PlexusResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "The route cannot have zero repository members!", (Object)this.getNexusErrorResponse("repositories", "The route cannot have zero repository members!"));
            }
            if ("blocking".equals(resource.getRuleType())) {
                resource.setRepositories(null);
            }
            resource.setId(Long.toHexString(System.nanoTime()));
            try {
                ArrayList<String> mappedReposes = new ArrayList<String>(resource.getRepositories().size());
                for (RepositoryRouteMemberRepository member : resource.getRepositories()) {
                    mappedReposes.add(member.getId());
                }
                RepositoryPathMapping route = new RepositoryPathMapping(resource.getId(), this.resource2configType(resource.getRuleType()), resource.getGroupId(), Arrays.asList(resource.getPattern()), mappedReposes);
                this.getRepositoryMapper().addMapping(route);
                this.getNexusConfiguration().saveConfiguration();
                resource.setGroupId(route.getGroupId());
                result = new RepositoryRouteResourceResponse();
                result.setData(resource);
            }
            catch (ConfigurationException e) {
                if (e.getCause() != null && e.getCause() instanceof PatternSyntaxException) {
                    throw new PlexusResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Configuration error.", (Object)this.getNexusErrorResponse("pattern", e.getMessage()));
                }
                this.handleConfigurationException(e);
            }
            catch (PatternSyntaxException e) {
                ErrorResponse errorResponse = this.getNexusErrorResponse("*", e.getMessage());
                throw new PlexusResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Configuration error.", (Object)errorResponse);
            }
            catch (IOException e) {
                this.getLogger().warn("Got IO Exception!", (Throwable)e);
                throw new ResourceException(Status.SERVER_ERROR_INTERNAL);
            }
        }
        return result;
    }
}

