/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.routes;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.mapping.RepositoryPathMapping;
import org.sonatype.nexus.proxy.mapping.RequestRepositoryMapper;
import org.sonatype.nexus.rest.AbstractNexusPlexusResource;
import org.sonatype.nexus.rest.NoSuchRepositoryAccessException;
import org.sonatype.nexus.rest.model.RepositoryRouteMemberRepository;

public abstract class AbstractRepositoryRoutePlexusResource
extends AbstractNexusPlexusResource {
    public static final String ROUTE_ID_KEY = "routeId";
    private RequestRepositoryMapper repositoryMapper;

    @Inject
    public void setRepositoryMapper(RequestRepositoryMapper repositoryMapper) {
        this.repositoryMapper = repositoryMapper;
    }

    protected RequestRepositoryMapper getRepositoryMapper() {
        return this.repositoryMapper;
    }

    protected List<RepositoryRouteMemberRepository> getRepositoryRouteMemberRepositoryList(Reference listBase, List<String> reposList, Request request, String mapId) throws NoSuchRepositoryAccessException {
        ArrayList<RepositoryRouteMemberRepository> members = new ArrayList<RepositoryRouteMemberRepository>(reposList.size());
        for (String repoId : reposList) {
            RepositoryRouteMemberRepository member = new RepositoryRouteMemberRepository();
            if ("*".equals(repoId)) {
                member.setId("*");
                member.setName("ALL");
                member.setResourceURI(null);
            } else {
                member.setId(repoId);
                try {
                    member.setName(this.getRepositoryRegistry().getRepository(repoId).getName());
                }
                catch (NoSuchRepositoryAccessException e) {
                    throw e;
                }
                catch (NoSuchRepositoryException e) {
                    this.getLogger().warn("Cannot find repository '" + repoId + "' declared within route: + '" + mapId + "'!", (Throwable)e);
                    continue;
                }
                member.setResourceURI(this.createChildReference(request, this, repoId).toString());
            }
            members.add(member);
        }
        return members;
    }

    protected RepositoryPathMapping.MappingType resource2configType(String type) {
        if ("inclusive".equals(type)) {
            return RepositoryPathMapping.MappingType.INCLUSION;
        }
        if ("exclusive".equals(type)) {
            return RepositoryPathMapping.MappingType.EXCLUSION;
        }
        if ("blocking".equals(type)) {
            return RepositoryPathMapping.MappingType.BLOCKING;
        }
        return null;
    }

    protected String config2resourceType(RepositoryPathMapping.MappingType type) {
        if (RepositoryPathMapping.MappingType.INCLUSION.equals((Object)type)) {
            return "inclusive";
        }
        if (RepositoryPathMapping.MappingType.EXCLUSION.equals((Object)type)) {
            return "exclusive";
        }
        if (RepositoryPathMapping.MappingType.BLOCKING.equals((Object)type)) {
            return "blocking";
        }
        return null;
    }
}

