/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.restore;

import java.util.concurrent.RejectedExecutionException;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.restlet.data.Request;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.repository.ShadowRepository;
import org.sonatype.nexus.rest.AbstractNexusPlexusResource;
import org.sonatype.nexus.scheduling.NexusScheduler;
import org.sonatype.nexus.scheduling.NexusTask;

public abstract class AbstractRestorePlexusResource
extends AbstractNexusPlexusResource {
    public static final String DOMAIN = "domain";
    public static final String DOMAIN_REPOSITORIES = "repositories";
    public static final String DOMAIN_REPO_GROUPS = "repo_groups";
    public static final String TARGET_ID = "target";
    private NexusScheduler nexusScheduler;

    public AbstractRestorePlexusResource() {
        this.setModifiable(true);
    }

    @Inject
    public void setNexusScheduler(NexusScheduler nexusScheduler) {
        this.nexusScheduler = nexusScheduler;
    }

    protected NexusScheduler getNexusScheduler() {
        return this.nexusScheduler;
    }

    protected String getRepositoryId(Request request) throws ResourceException {
        String repoId = null;
        if (request.getAttributes().containsKey(DOMAIN) && request.getAttributes().containsKey(TARGET_ID) && DOMAIN_REPOSITORIES.equals(request.getAttributes().get(DOMAIN))) {
            repoId = request.getAttributes().get(TARGET_ID).toString();
            try {
                this.getRepositoryRegistry().getRepositoryWithFacet(repoId, Repository.class);
            }
            catch (NoSuchRepositoryException e) {
                throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "Repository not found!", (Throwable)e);
            }
        }
        return repoId;
    }

    protected String getRepositoryGroupId(Request request) throws ResourceException {
        String groupId = null;
        if (request.getAttributes().containsKey(DOMAIN) && request.getAttributes().containsKey(TARGET_ID) && DOMAIN_REPO_GROUPS.equals(request.getAttributes().get(DOMAIN))) {
            groupId = request.getAttributes().get(TARGET_ID).toString();
            try {
                this.getRepositoryRegistry().getRepositoryWithFacet(groupId, GroupRepository.class);
            }
            catch (NoSuchRepositoryException e) {
                throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "Repository group not found!", (Throwable)e);
            }
        }
        return groupId;
    }

    protected String getResourceStorePath(Request request) throws ResourceException {
        String path = null;
        if (this.getRepositoryId(request) != null || this.getRepositoryGroupId(request) != null) {
            path = request.getResourceRef().getRemainingPart();
            if (path.contains("?")) {
                path = path.substring(0, path.indexOf(63));
            }
            if (path.contains("#")) {
                path = path.substring(0, path.indexOf(35));
            }
            if (StringUtils.isEmpty((String)path)) {
                path = "/";
            }
        }
        return path;
    }

    public void handleDelete(NexusTask<?> task, Request request) throws ResourceException {
        try {
            if (this.getRepositoryGroupId(request) != null) {
                this.getRepositoryRegistry().getRepositoryWithFacet(this.getRepositoryGroupId(request), GroupRepository.class);
            } else if (this.getRepositoryId(request) != null) {
                try {
                    this.getRepositoryRegistry().getRepository(this.getRepositoryId(request));
                }
                catch (NoSuchRepositoryException e) {
                    this.getRepositoryRegistry().getRepositoryWithFacet(this.getRepositoryId(request), ShadowRepository.class);
                }
            }
            this.getNexusScheduler().submit("Internal", task);
            throw new ResourceException(Status.SUCCESS_NO_CONTENT);
        }
        catch (RejectedExecutionException e) {
            throw new ResourceException(Status.CLIENT_ERROR_CONFLICT, e.getMessage());
        }
        catch (NoSuchRepositoryException e) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, e.getMessage());
        }
    }
}

