/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.repotargets;

import java.io.IOException;
import java.util.regex.PatternSyntaxException;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.nexus.proxy.targets.Target;
import org.sonatype.nexus.rest.model.RepositoryTargetResource;
import org.sonatype.nexus.rest.model.RepositoryTargetResourceResponse;
import org.sonatype.nexus.rest.repotargets.AbstractRepositoryTargetPlexusResource;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResourceException;
import org.sonatype.plexus.rest.resource.error.ErrorResponse;

@Named
@Singleton
@Path(value="/repo_targets/{repoTargetId}")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
public class RepositoryTargetPlexusResource
extends AbstractRepositoryTargetPlexusResource {
    public static final String REPO_TARGET_ID_KEY = "repoTargetId";
    public static final String RESOURCE_URI = "/repo_targets/{repoTargetId}";

    public RepositoryTargetPlexusResource() {
        this.setModifiable(true);
    }

    public Object getPayloadInstance() {
        return new RepositoryTargetResourceResponse();
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/repo_targets/*", "authcBasic,perms[nexus:targets]");
    }

    private String getRepoTargetId(Request request) {
        return request.getAttributes().get(REPO_TARGET_ID_KEY).toString();
    }

    @GET
    @ResourceMethodSignature(pathParams={@PathParam(value="repoTargetId")}, output=RepositoryTargetResourceResponse.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        RepositoryTargetResourceResponse result = new RepositoryTargetResourceResponse();
        Target target = this.getTargetRegistry().getRepositoryTarget(this.getRepoTargetId(request));
        if (target == null) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "No such target!");
        }
        RepositoryTargetResource resource = this.getNexusToRestResource(target, request);
        result.setData(resource);
        return result;
    }

    @PUT
    @ResourceMethodSignature(pathParams={@PathParam(value="repoTargetId")}, input=RepositoryTargetResourceResponse.class, output=RepositoryTargetResourceResponse.class)
    public Object put(Context context, Request request, Response response, Object payload) throws ResourceException {
        RepositoryTargetResourceResponse requestResource = (RepositoryTargetResourceResponse)payload;
        RepositoryTargetResourceResponse resultResource = null;
        if (requestResource != null) {
            RepositoryTargetResource resource = requestResource.getData();
            Target target = this.getTargetRegistry().getRepositoryTarget(this.getRepoTargetId(request));
            if (target != null) {
                if (this.validate(false, resource)) {
                    try {
                        target = this.getRestToNexusResource(resource);
                        this.getTargetRegistry().addRepositoryTarget(target);
                        this.getNexusConfiguration().saveConfiguration();
                        resultResource = new RepositoryTargetResourceResponse();
                        resultResource.setData(requestResource.getData());
                    }
                    catch (ConfigurationException e) {
                        this.handleConfigurationException(e);
                    }
                    catch (PatternSyntaxException e) {
                        ErrorResponse errorResponse = this.getNexusErrorResponse("*", e.getMessage());
                        throw new PlexusResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Configuration error.", (Object)errorResponse);
                    }
                    catch (IOException e) {
                        this.getLogger().warn("Got IOException during creation of repository target!", (Throwable)e);
                        throw new ResourceException(Status.SERVER_ERROR_INTERNAL, "Got IOException during creation of repository target!");
                    }
                }
            } else {
                throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "No such target!");
            }
        }
        return resultResource;
    }

    @DELETE
    @ResourceMethodSignature(pathParams={@PathParam(value="repoTargetId")})
    public void delete(Context context, Request request, Response response) throws ResourceException {
        Target target = this.getTargetRegistry().getRepositoryTarget(this.getRepoTargetId(request));
        if (target != null) {
            try {
                this.getTargetRegistry().removeRepositoryTarget(this.getRepoTargetId(request));
                this.getNexusConfiguration().saveConfiguration();
            }
            catch (IOException e) {
                this.getLogger().warn("Got IOException during removal of repository target!", (Throwable)e);
                throw new ResourceException(Status.SERVER_ERROR_INTERNAL, "Got IOException during removal of repository target!");
            }
        } else {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "No such target!");
        }
    }
}

