/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.repotargets;

import java.io.IOException;
import java.util.Collection;
import java.util.regex.PatternSyntaxException;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.nexus.proxy.targets.Target;
import org.sonatype.nexus.rest.model.RepositoryTargetListResource;
import org.sonatype.nexus.rest.model.RepositoryTargetListResourceResponse;
import org.sonatype.nexus.rest.model.RepositoryTargetResource;
import org.sonatype.nexus.rest.model.RepositoryTargetResourceResponse;
import org.sonatype.nexus.rest.repotargets.AbstractRepositoryTargetPlexusResource;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResourceException;
import org.sonatype.plexus.rest.resource.error.ErrorResponse;

@Named
@Singleton
@Path(value="/repo_targets")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
public class RepositoryTargetListPlexusResource
extends AbstractRepositoryTargetPlexusResource {
    public static final String RESOURCE_URI = "/repo_targets";

    public RepositoryTargetListPlexusResource() {
        this.setModifiable(true);
    }

    public Object getPayloadInstance() {
        return new RepositoryTargetResourceResponse();
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor(this.getResourceUri(), "authcBasic,perms[nexus:targets]");
    }

    @GET
    @ResourceMethodSignature(output=RepositoryTargetListResourceResponse.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        RepositoryTargetListResourceResponse result = new RepositoryTargetListResourceResponse();
        Collection targets = this.getTargetRegistry().getRepositoryTargets();
        RepositoryTargetListResource res = null;
        for (Target target : targets) {
            res = new RepositoryTargetListResource();
            res.setId(target.getId());
            res.setName(target.getName());
            res.setContentClass(target.getContentClass().getId());
            res.setResourceURI(this.createChildReference(request, this, target.getId()).toString());
            for (String pattern : target.getPatternTexts()) {
                res.addPattern(pattern);
            }
            result.addData(res);
        }
        return result;
    }

    @POST
    @ResourceMethodSignature(input=RepositoryTargetResourceResponse.class, output=RepositoryTargetResourceResponse.class)
    public Object post(Context context, Request request, Response response, Object payload) throws ResourceException {
        RepositoryTargetResource resource;
        RepositoryTargetResourceResponse result = (RepositoryTargetResourceResponse)payload;
        RepositoryTargetResourceResponse resourceResponse = null;
        if (result != null && this.validate(true, resource = result.getData())) {
            try {
                Target target = this.getRestToNexusResource(resource);
                this.getTargetRegistry().addRepositoryTarget(target);
                this.getNexusConfiguration().saveConfiguration();
                resourceResponse = new RepositoryTargetResourceResponse();
                resourceResponse.setData(result.getData());
            }
            catch (ConfigurationException e) {
                this.handleConfigurationException(e);
            }
            catch (PatternSyntaxException e) {
                ErrorResponse errorResponse = this.getNexusErrorResponse("*", e.getMessage());
                throw new PlexusResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Configuration error.", (Object)errorResponse);
            }
            catch (IOException e) {
                this.getLogger().warn("Got IOException during creation of repository target!", (Throwable)e);
                throw new ResourceException(Status.SERVER_ERROR_INTERNAL, "Got IOException during creation of repository target!");
            }
        }
        return resourceResponse;
    }
}

