/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.repotargets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.PatternSyntaxException;
import javax.inject.Inject;
import org.restlet.data.Request;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.nexus.proxy.registry.ContentClass;
import org.sonatype.nexus.proxy.registry.RepositoryTypeRegistry;
import org.sonatype.nexus.proxy.targets.Target;
import org.sonatype.nexus.proxy.targets.TargetRegistry;
import org.sonatype.nexus.rest.AbstractNexusPlexusResource;
import org.sonatype.nexus.rest.model.RepositoryTargetResource;

public abstract class AbstractRepositoryTargetPlexusResource
extends AbstractNexusPlexusResource {
    private TargetRegistry targetRegistry;
    private RepositoryTypeRegistry repositoryTypeRegistry;

    @Inject
    public void setTargetRegistry(TargetRegistry targetRegistry) {
        this.targetRegistry = targetRegistry;
    }

    @Inject
    public void setRepositoryTypeRegistry(RepositoryTypeRegistry repositoryTypeRegistry) {
        this.repositoryTypeRegistry = repositoryTypeRegistry;
    }

    protected TargetRegistry getTargetRegistry() {
        return this.targetRegistry;
    }

    protected RepositoryTypeRegistry getRepositoryTypeRegistry() {
        return this.repositoryTypeRegistry;
    }

    protected RepositoryTargetResource getNexusToRestResource(Target target, Request request) {
        RepositoryTargetResource resource = new RepositoryTargetResource();
        resource.setId(target.getId());
        resource.setName(target.getName());
        resource.setResourceURI(request.getResourceRef().getPath());
        resource.setContentClass(target.getContentClass().getId());
        ArrayList patterns = new ArrayList(target.getPatternTexts());
        for (String pattern : patterns) {
            resource.addPattern(pattern);
        }
        return resource;
    }

    protected Target getRestToNexusResource(RepositoryTargetResource resource) throws ConfigurationException, PatternSyntaxException {
        ContentClass cc = (ContentClass)this.getRepositoryTypeRegistry().getContentClasses().get(resource.getContentClass());
        if (cc == null) {
            throw new ConfigurationException("Content class with ID=\"" + resource.getContentClass() + "\" does not exists!");
        }
        Target target = new Target(resource.getId(), resource.getName(), cc, (Collection)resource.getPatterns());
        return target;
    }

    protected boolean validate(boolean isNew, RepositoryTargetResource resource) {
        if (isNew && resource.getId() == null) {
            resource.setId(Long.toHexString(System.nanoTime()));
        }
        return resource.getId() != null;
    }
}

