/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.repositorystatuses;

import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ThreadContext;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.rest.model.RepositoryStatusListResource;
import org.sonatype.nexus.rest.model.RepositoryStatusListResourceResponse;
import org.sonatype.nexus.rest.model.RepositoryStatusResource;
import org.sonatype.nexus.rest.repositories.AbstractRepositoryPlexusResource;
import org.sonatype.nexus.util.SystemPropertiesHelper;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;

@Named
@Singleton
@Path(value="/repository_statuses")
@Produces(value={"application/xml", "application/json"})
public class RepositoryStatusesListPlexusResource
extends AbstractRepositoryPlexusResource {
    public static final String RESOURCE_URI = "/repository_statuses";
    private static final String ADMIN_ONLY_KEY = "nexus.repositoryStatuses.adminOnly";
    private final boolean adminOnly = SystemPropertiesHelper.getBoolean((String)"nexus.repositoryStatuses.adminOnly", (boolean)false);

    public Object getPayloadInstance() {
        return null;
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor(this.getResourceUri(), "authcBasic,perms[nexus:repostatus]");
    }

    @GET
    @ResourceMethodSignature(queryParams={@QueryParam(value="forceCheck")}, output=RepositoryStatusListResourceResponse.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        Subject subject;
        if (this.adminOnly && ((subject = ThreadContext.getSubject()) == null || !subject.isPermitted("nexus:repostatus:update"))) {
            response.setStatus(Status.SUCCESS_NO_CONTENT);
            return null;
        }
        RepositoryStatusListResourceResponse result = new RepositoryStatusListResourceResponse();
        List repositories = this.getRepositoryRegistry().getRepositories();
        for (Repository repository : repositories) {
            RepositoryStatusListResource repoRes = new RepositoryStatusListResource();
            repoRes.setResourceURI(this.createChildReference(request, this, repository.getId()).toString());
            repoRes.setId(repository.getId());
            repoRes.setName(repository.getName());
            repoRes.setRepoType(this.getRestRepoType(repository));
            if (repository.getRepositoryKind().isFacetAvailable(MavenRepository.class)) {
                repoRes.setRepoPolicy(((MavenRepository)repository.adaptToFacet(MavenRepository.class)).getRepositoryPolicy().toString());
            }
            repoRes.setFormat(repository.getRepositoryContentClass().getId());
            repoRes.setStatus(new RepositoryStatusResource());
            repoRes.getStatus().setLocalStatus(repository.getLocalStatus().toString());
            if (repository.getRepositoryKind().isFacetAvailable(ProxyRepository.class)) {
                repoRes.getStatus().setRemoteStatus(this.getRestRepoRemoteStatus((ProxyRepository)repository.adaptToFacet(ProxyRepository.class), request, response));
                repoRes.getStatus().setProxyMode(((ProxyRepository)repository.adaptToFacet(ProxyRepository.class)).getProxyMode().toString());
            }
            result.addData(repoRes);
        }
        return result;
    }
}

