/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.repositories;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Form;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.HostedRepository;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.ShadowRepository;
import org.sonatype.nexus.rest.AbstractNexusPlexusResource;
import org.sonatype.nexus.rest.model.NexusRepositoryTypeListResource;
import org.sonatype.nexus.rest.model.NexusRepositoryTypeListResourceResponse;
import org.sonatype.nexus.templates.Template;
import org.sonatype.nexus.templates.TemplateSet;
import org.sonatype.nexus.templates.repository.AbstractRepositoryTemplate;
import org.sonatype.nexus.templates.repository.RepositoryTemplate;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;

@Named
@Singleton
@Path(value="/components/repo_types")
@Produces(value={"application/xml", "application/json"})
public class RepositoryTypesComponentListPlexusResource
extends AbstractNexusPlexusResource {
    public static final String RESOURCE_URI = "/components/repo_types";
    private static final Pattern BRACKETS_PATTERN = Pattern.compile("(.*)( \\(.*\\))");

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor(this.getResourceUri(), "authcBasic,perms[nexus:componentsrepotypes]");
    }

    public Object getPayloadInstance() {
        return null;
    }

    @GET
    @ResourceMethodSignature(queryParams={@QueryParam(value="repoType")}, output=NexusRepositoryTypeListResourceResponse.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        Form form = request.getResourceRef().getQueryAsForm();
        String repoType = form.getFirstValue("repoType");
        TemplateSet templateSet = this.getRepositoryTemplates();
        if ("hosted".equals(repoType)) {
            templateSet = templateSet.getTemplates(HostedRepository.class);
        } else if ("proxy".equals(repoType)) {
            templateSet = templateSet.getTemplates(ProxyRepository.class);
        } else if ("shadow".equals(repoType)) {
            templateSet = templateSet.getTemplates(ShadowRepository.class);
        } else if ("group".equals(repoType)) {
            templateSet = templateSet.getTemplates(GroupRepository.class);
        }
        NexusRepositoryTypeListResourceResponse result = new NexusRepositoryTypeListResourceResponse();
        if (templateSet.getTemplatesList().isEmpty()) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND);
        }
        for (Template template : templateSet.getTemplatesList()) {
            NexusRepositoryTypeListResource resource = new NexusRepositoryTypeListResource();
            String providerRole = ((RepositoryTemplate)template).getRepositoryProviderRole();
            String providerHint = ((RepositoryTemplate)template).getRepositoryProviderHint();
            resource.setProvider(providerHint);
            resource.setProviderRole(providerRole);
            resource.setFormat(((AbstractRepositoryTemplate)template).getContentClass().getId());
            resource.setDescription(this.removeBrackets(template.getDescription()));
            result.addData(resource);
        }
        return result;
    }

    protected String removeBrackets(String val) {
        Matcher m = BRACKETS_PATTERN.matcher(val);
        if (m.matches() && m.groupCount() == 2) {
            return m.group(1);
        }
        return val;
    }
}

