/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.repositories;

import java.io.IOException;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.repository.LocalStatus;
import org.sonatype.nexus.proxy.repository.ProxyMode;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.repository.ShadowRepository;
import org.sonatype.nexus.rest.NoSuchRepositoryAccessException;
import org.sonatype.nexus.rest.model.RepositoryDependentStatusResource;
import org.sonatype.nexus.rest.model.RepositoryStatusResource;
import org.sonatype.nexus.rest.model.RepositoryStatusResourceResponse;
import org.sonatype.nexus.rest.repositories.AbstractRepositoryPlexusResource;
import org.sonatype.nexus.rest.util.EnumUtil;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;

@Named
@Singleton
@Path(value="/repositories/{repositoryId}/status")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
public class RepositoryStatusPlexusResource
extends AbstractRepositoryPlexusResource {
    public static final String RESOURCE_URI = "/repositories/{repositoryId}/status";

    public RepositoryStatusPlexusResource() {
        this.setModifiable(true);
    }

    public Object getPayloadInstance() {
        return new RepositoryStatusResourceResponse();
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/repositories/*/status", "authcBasic,perms[nexus:repostatus]");
    }

    @GET
    @ResourceMethodSignature(pathParams={@PathParam(value="repositoryId")}, output=RepositoryStatusResourceResponse.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        RepositoryStatusResourceResponse result = null;
        String repoId = this.getRepositoryId(request);
        try {
            RepositoryStatusResource resource = new RepositoryStatusResource();
            Repository repo = this.getRepositoryRegistry().getRepository(repoId);
            resource.setId(repo.getId());
            resource.setRepoType(this.getRestRepoType(repo));
            resource.setFormat(repo.getRepositoryContentClass().getId());
            resource.setLocalStatus(repo.getLocalStatus().toString());
            if (repo.getRepositoryKind().isFacetAvailable(ProxyRepository.class)) {
                ProxyRepository prepo = (ProxyRepository)repo.adaptToFacet(ProxyRepository.class);
                resource.setRemoteStatus(this.getRestRepoRemoteStatus(prepo, request, response));
                resource.setProxyMode(prepo.getProxyMode().toString());
            }
            result = new RepositoryStatusResourceResponse();
            result.setData(resource);
        }
        catch (NoSuchRepositoryAccessException e) {
            this.getLogger().warn("Repository access denied, id=" + repoId);
            throw new ResourceException(Status.CLIENT_ERROR_FORBIDDEN, "Access Denied to Repository");
        }
        catch (NoSuchRepositoryException e) {
            this.getLogger().warn("Repository not found, id=" + repoId);
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "Repository Not Found");
        }
        return result;
    }

    @PUT
    @ResourceMethodSignature(pathParams={@PathParam(value="repositoryId")}, input=RepositoryStatusResourceResponse.class, output=RepositoryStatusResourceResponse.class)
    public Object put(Context context, Request request, Response response, Object payload) throws ResourceException {
        RepositoryStatusResourceResponse repoStatusRequest = (RepositoryStatusResourceResponse)payload;
        RepositoryStatusResourceResponse result = null;
        String repoId = this.getRepositoryId(request);
        if (repoStatusRequest != null) {
            try {
                RepositoryStatusResource resource = repoStatusRequest.getData();
                if (resource.getLocalStatus() == null) {
                    throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Local status must be defined");
                }
                LocalStatus localStatus = EnumUtil.valueOf(resource.getLocalStatus(), LocalStatus.class);
                if ("virtual".equals(resource.getRepoType())) {
                    ShadowRepository shadow = (ShadowRepository)this.getRepositoryRegistry().getRepositoryWithFacet(repoId, ShadowRepository.class);
                    shadow.setLocalStatus(localStatus);
                    this.getNexusConfiguration().saveConfiguration();
                    result = (RepositoryStatusResourceResponse)this.get(context, request, response, null);
                } else {
                    Repository repository = this.getRepositoryRegistry().getRepository(repoId);
                    repository.setLocalStatus(localStatus);
                    if (repository.getRepositoryKind().isFacetAvailable(ProxyRepository.class) && resource.getProxyMode() != null) {
                        ProxyMode proxyMode = EnumUtil.valueOf(resource.getProxyMode(), ProxyMode.class);
                        ((ProxyRepository)repository.adaptToFacet(ProxyRepository.class)).setProxyMode(proxyMode);
                    }
                    for (ShadowRepository shadow : this.getRepositoryRegistry().getRepositoriesWithFacet(ShadowRepository.class)) {
                        if (!repository.getId().equals(shadow.getMasterRepository().getId())) continue;
                        shadow.setLocalStatus(localStatus);
                    }
                    this.getNexusConfiguration().saveConfiguration();
                    result = (RepositoryStatusResourceResponse)this.get(context, request, response, null);
                    for (ShadowRepository shadow : this.getRepositoryRegistry().getRepositoriesWithFacet(ShadowRepository.class)) {
                        if (!repository.getId().equals(shadow.getMasterRepository().getId())) continue;
                        RepositoryDependentStatusResource dependent = new RepositoryDependentStatusResource();
                        dependent.setId(shadow.getId());
                        dependent.setRepoType(this.getRestRepoType((Repository)shadow));
                        dependent.setFormat(shadow.getRepositoryContentClass().getId());
                        dependent.setLocalStatus(shadow.getLocalStatus().toString());
                        result.getData().addDependentRepo(dependent);
                    }
                }
            }
            catch (NoSuchRepositoryAccessException e) {
                this.getLogger().warn("Repository access denied, id=" + repoId);
                throw new ResourceException(Status.CLIENT_ERROR_FORBIDDEN, "Access Denied to Repository");
            }
            catch (NoSuchRepositoryException e) {
                this.getLogger().warn("Repository not found, id=" + repoId);
                throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "Repository Not Found");
            }
            catch (IOException e) {
                this.getLogger().warn("Got IO Exception!", (Throwable)e);
                throw new ResourceException(Status.SERVER_ERROR_INTERNAL);
            }
        }
        return result;
    }
}

