/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.repositories;

import java.io.IOException;
import java.lang.reflect.Method;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.configuration.validation.ValidationMessage;
import org.sonatype.configuration.validation.ValidationResponse;
import org.sonatype.nexus.configuration.application.RepositoryDependentException;
import org.sonatype.nexus.configuration.validator.ApplicationValidationResponse;
import org.sonatype.nexus.proxy.AccessDeniedException;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.RemoteStorageException;
import org.sonatype.nexus.proxy.StorageException;
import org.sonatype.nexus.proxy.maven.ChecksumPolicy;
import org.sonatype.nexus.proxy.maven.MavenProxyRepository;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.maven.RepositoryPolicy;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.RemoteAuthenticationSettings;
import org.sonatype.nexus.proxy.repository.RemoteConnectionSettings;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.repository.RepositoryWritePolicy;
import org.sonatype.nexus.proxy.repository.ShadowRepository;
import org.sonatype.nexus.proxy.repository.UsernamePasswordRemoteAuthenticationSettings;
import org.sonatype.nexus.rest.NoSuchRepositoryAccessException;
import org.sonatype.nexus.rest.model.RepositoryBaseResource;
import org.sonatype.nexus.rest.model.RepositoryProxyResource;
import org.sonatype.nexus.rest.model.RepositoryResource;
import org.sonatype.nexus.rest.model.RepositoryResourceResponse;
import org.sonatype.nexus.rest.model.RepositoryShadowResource;
import org.sonatype.nexus.rest.repositories.AbstractRepositoryPlexusResource;
import org.sonatype.nexus.rest.util.EnumUtil;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResourceException;
import org.sonatype.plexus.rest.resource.error.ErrorResponse;

@Named
@Singleton
@Path(value="/repositories/{repositoryId}")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
public class RepositoryPlexusResource
extends AbstractRepositoryPlexusResource {
    public static final String RESOURCE_URI = "/repositories/{repositoryId}";

    public RepositoryPlexusResource() {
        this.setModifiable(true);
    }

    public Object getPayloadInstance() {
        return new RepositoryResourceResponse();
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/repositories/*", "authcBasic,perms[nexus:repositories]");
    }

    @GET
    @ResourceMethodSignature(pathParams={@PathParam(value="repositoryId")}, output=RepositoryResourceResponse.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        return this.getRepositoryResourceResponse(request, this.getRepositoryId(request));
    }

    @PUT
    @ResourceMethodSignature(pathParams={@PathParam(value="repositoryId")}, input=RepositoryResourceResponse.class, output=RepositoryResourceResponse.class)
    public Object put(Context context, Request request, Response response, Object payload) throws ResourceException {
        block29: {
            RepositoryResourceResponse repoRequest = (RepositoryResourceResponse)payload;
            String repoId = this.getRepositoryId(request);
            if (repoRequest != null) {
                try {
                    RepositoryBaseResource resource = repoRequest.getData();
                    if ("virtual".equals(resource.getRepoType())) {
                        RepositoryShadowResource model = (RepositoryShadowResource)resource;
                        try {
                            ShadowRepository shadow = (ShadowRepository)this.getRepositoryRegistry().getRepositoryWithFacet(repoId, ShadowRepository.class);
                            shadow.setName(model.getName());
                            shadow.setExposed(resource.isExposed());
                            shadow.setMasterRepository(this.getRepositoryRegistry().getRepository(model.getShadowOf()));
                            shadow.setSynchronizeAtStartup(model.isSyncAtStartup());
                            this.getNexusConfiguration().saveConfiguration();
                            break block29;
                        }
                        catch (NoSuchRepositoryAccessException e) {
                            this.getLogger().warn("Repository access denied, id=" + repoId);
                            throw new ResourceException(Status.CLIENT_ERROR_FORBIDDEN, "Access Denied to Repository");
                        }
                        catch (NoSuchRepositoryException e) {
                            this.getLogger().warn("Virtual repository not found, id=" + repoId);
                            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "Virtual repository Not Found");
                        }
                    }
                    RepositoryResource model = (RepositoryResource)resource;
                    try {
                        Repository repository = this.getRepositoryRegistry().getRepository(repoId);
                        repository.setName(model.getName());
                        repository.setExposed(resource.isExposed());
                        RepositoryWritePolicy writePolicy = model.getWritePolicy() != null ? RepositoryWritePolicy.valueOf((String)model.getWritePolicy()) : RepositoryWritePolicy.READ_ONLY;
                        repository.setWritePolicy(writePolicy);
                        repository.setBrowseable(model.isBrowseable());
                        repository.setIndexable(model.isIndexable());
                        repository.setSearchable(model.isIndexable());
                        repository.setNotFoundCacheTimeToLive(model.getNotFoundCacheTTL());
                        if (repository.getRepositoryKind().isFacetAvailable(ProxyRepository.class)) {
                            ProxyRepository proxyRepo = (ProxyRepository)repository.adaptToFacet(ProxyRepository.class);
                            try {
                                proxyRepo.setRemoteUrl(model.getRemoteStorage().getRemoteStorageUrl());
                            }
                            catch (RemoteStorageException e) {
                                ApplicationValidationResponse vr = new ApplicationValidationResponse();
                                ValidationMessage error = new ValidationMessage("remoteStorageUrl", e.getMessage(), e.getMessage());
                                vr.addValidationError(error);
                                throw new InvalidConfigurationException((ValidationResponse)vr);
                            }
                            String oldPasswordForRemoteStorage = null;
                            if (proxyRepo.getRemoteAuthenticationSettings() != null && UsernamePasswordRemoteAuthenticationSettings.class.isInstance(proxyRepo.getRemoteAuthenticationSettings())) {
                                oldPasswordForRemoteStorage = ((UsernamePasswordRemoteAuthenticationSettings)proxyRepo.getRemoteAuthenticationSettings()).getPassword();
                            }
                            RemoteAuthenticationSettings remoteAuth = this.getAuthenticationInfoConverter().convertAndValidateFromModel(this.convertAuthentication(model.getRemoteStorage().getAuthentication(), oldPasswordForRemoteStorage));
                            RemoteConnectionSettings remoteConnSettings = this.getGlobalRemoteConnectionSettings().convertAndValidateFromModel(this.convertRemoteConnectionSettings(model.getRemoteStorage().getConnectionSettings()));
                            if (remoteAuth != null) {
                                proxyRepo.setRemoteAuthenticationSettings(remoteAuth);
                            } else {
                                proxyRepo.getRemoteStorageContext().removeRemoteAuthenticationSettings();
                            }
                            if (remoteConnSettings != null) {
                                proxyRepo.setRemoteConnectionSettings(remoteConnSettings);
                            } else {
                                proxyRepo.getRemoteStorageContext().removeRemoteConnectionSettings();
                            }
                            proxyRepo.setAutoBlockActive(((RepositoryProxyResource)model).isAutoBlockActive());
                            proxyRepo.setFileTypeValidation(((RepositoryProxyResource)model).isFileTypeValidation());
                        }
                        if (repository.getRepositoryKind().isFacetAvailable(MavenRepository.class)) {
                            RepositoryPolicy repoPolicy = EnumUtil.valueOf(model.getRepoPolicy(), RepositoryPolicy.class);
                            ((MavenRepository)repository.adaptToFacet(MavenRepository.class)).setRepositoryPolicy(repoPolicy);
                            if (repository.getRepositoryKind().isFacetAvailable(MavenProxyRepository.class)) {
                                ChecksumPolicy checksum = EnumUtil.valueOf(model.getChecksumPolicy(), ChecksumPolicy.class);
                                MavenProxyRepository pRepository = (MavenProxyRepository)repository.adaptToFacet(MavenProxyRepository.class);
                                pRepository.setChecksumPolicy(checksum);
                                pRepository.setDownloadRemoteIndexes(model.isDownloadRemoteIndexes());
                                pRepository.setChecksumPolicy(EnumUtil.valueOf(model.getChecksumPolicy(), ChecksumPolicy.class));
                                pRepository.setDownloadRemoteIndexes(model.isDownloadRemoteIndexes());
                                RepositoryProxyResource proxyModel = (RepositoryProxyResource)model;
                                pRepository.setArtifactMaxAge(proxyModel.getArtifactMaxAge());
                                pRepository.setMetadataMaxAge(proxyModel.getMetadataMaxAge());
                                if (proxyModel.getItemMaxAge() != null) {
                                    pRepository.setItemMaxAge(proxyModel.getItemMaxAge().intValue());
                                }
                            }
                        } else {
                            try {
                                Method metadataMethod;
                                Method artifactMethod;
                                RepositoryProxyResource proxyModel = (RepositoryProxyResource)model;
                                Method itemMethod = repository.getClass().getMethod("setItemMaxAge", Integer.TYPE);
                                if (itemMethod != null && proxyModel.getItemMaxAge() != null) {
                                    itemMethod.invoke((Object)repository, proxyModel.getItemMaxAge());
                                }
                                if ((artifactMethod = repository.getClass().getMethod("setArtifactMaxAge", Integer.TYPE)) != null) {
                                    artifactMethod.invoke((Object)repository, proxyModel.getArtifactMaxAge());
                                }
                                if ((metadataMethod = repository.getClass().getMethod("setMetadataMaxAge", Integer.TYPE)) != null) {
                                    metadataMethod.invoke((Object)repository, proxyModel.getMetadataMaxAge());
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        repository.setLocalUrl(model.getOverrideLocalStorageUrl());
                        this.getNexusConfiguration().saveConfiguration();
                    }
                    catch (NoSuchRepositoryAccessException e) {
                        this.getLogger().warn("Repository access denied, id=" + repoId);
                        throw new ResourceException(Status.CLIENT_ERROR_FORBIDDEN, "Access Denied to Repository");
                    }
                    catch (NoSuchRepositoryException e) {
                        this.getLogger().warn("Repository not found, id=" + repoId);
                        throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "Repository Not Found");
                    }
                }
                catch (ConfigurationException e) {
                    this.handleConfigurationException(e);
                }
                catch (StorageException e) {
                    ErrorResponse nexusErrorResponse = this.getNexusErrorResponse("*", e.getMessage());
                    throw new PlexusResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Configuration error.", (Object)nexusErrorResponse);
                }
                catch (IOException e) {
                    this.getLogger().warn("Got IO Exception!", (Throwable)e);
                    throw new ResourceException(Status.SERVER_ERROR_INTERNAL);
                }
            }
        }
        return this.getRepositoryResourceResponse(request, this.getRepositoryId(request));
    }

    @DELETE
    @ResourceMethodSignature(pathParams={@PathParam(value="repositoryId")})
    public void delete(Context context, Request request, Response response) throws ResourceException {
        String repoId = this.getRepositoryId(request);
        try {
            this.getNexusConfiguration().deleteRepository(repoId);
            response.setStatus(Status.SUCCESS_NO_CONTENT);
        }
        catch (RepositoryDependentException e) {
            this.getLogger().info(e.getMessage());
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, e.getUIMessage(), (Throwable)e);
        }
        catch (ConfigurationException e) {
            this.getLogger().warn(e.getMessage());
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, e.getMessage(), (Throwable)e);
        }
        catch (NoSuchRepositoryAccessException e) {
            this.getLogger().warn("Repository access denied, id=" + repoId);
            throw new ResourceException(Status.CLIENT_ERROR_FORBIDDEN, "Access Denied to Repository");
        }
        catch (NoSuchRepositoryException e) {
            this.getLogger().warn("Repository not found, id=" + repoId);
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "Repository Not Found");
        }
        catch (IOException e) {
            this.getLogger().warn("Got IO Exception!", (Throwable)e);
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL);
        }
        catch (AccessDeniedException e) {
            this.getLogger().warn("Not allowed to delete repository '" + repoId + "'", (Throwable)e);
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Not allowed to delete repository '" + repoId + "'");
        }
    }
}

