/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.repositories;

import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.cache.CacheStatistics;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.rest.NoSuchRepositoryAccessException;
import org.sonatype.nexus.rest.model.RepositoryMetaResource;
import org.sonatype.nexus.rest.model.RepositoryMetaResourceResponse;
import org.sonatype.nexus.rest.repositories.AbstractRepositoryPlexusResource;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;

@Named
@Singleton
@Path(value="/repositories/{repositoryId}/meta")
@Produces(value={"application/xml", "application/json"})
public class RepositoryMetaPlexusResource
extends AbstractRepositoryPlexusResource {
    public static final String RESOURCE_URI = "/repositories/{repositoryId}/meta";

    public Object getPayloadInstance() {
        return null;
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/repositories/*/meta", "authcBasic,perms[nexus:repometa]");
    }

    @GET
    @ResourceMethodSignature(pathParams={@PathParam(value="repositoryId")}, output=RepositoryMetaResourceResponse.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        String repoId = this.getRepositoryId(request);
        try {
            Repository repository = this.getRepositoryRegistry().getRepository(repoId);
            RepositoryMetaResource resource = new RepositoryMetaResource();
            resource.setId(repoId);
            resource.setRepoType(this.getRestRepoType(repository));
            resource.setFormat(repository.getRepositoryContentClass().getId());
            for (GroupRepository group : this.getRepositoryRegistry().getGroupsOfRepository(repository)) {
                resource.addGroup(group.getId());
            }
            resource.setFreeSpaceOnDisk(-1L);
            CacheStatistics stats = repository.getNotFoundCache().getStatistics();
            resource.setNotFoundCacheSize(stats.getSize());
            resource.setNotFoundCacheHits(stats.getHits());
            resource.setNotFoundCacheMisses(stats.getMisses());
            resource.setLocalStorageErrorsCount(0);
            resource.setRemoteStorageErrorsCount(0);
            RepositoryMetaResourceResponse result = new RepositoryMetaResourceResponse();
            result.setData(resource);
            return result;
        }
        catch (NoSuchRepositoryAccessException e) {
            this.getLogger().warn("Repository access denied, id=" + repoId);
            throw new ResourceException(Status.CLIENT_ERROR_FORBIDDEN, "Access Denied to Repository");
        }
        catch (NoSuchRepositoryException e) {
            this.getLogger().warn("Repository not found, id=" + repoId);
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "Repository Not Found");
        }
    }
}

