/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.repositories;

import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.commons.lang.StringUtils;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.nexus.configuration.model.CLocalStorage;
import org.sonatype.nexus.configuration.model.CRemoteStorage;
import org.sonatype.nexus.configuration.model.CRepository;
import org.sonatype.nexus.configuration.model.CRepositoryCoreConfiguration;
import org.sonatype.nexus.configuration.model.DefaultCRepository;
import org.sonatype.nexus.proxy.maven.ChecksumPolicy;
import org.sonatype.nexus.proxy.maven.RepositoryPolicy;
import org.sonatype.nexus.proxy.maven.maven2.M2LayoutedM1ShadowRepositoryConfiguration;
import org.sonatype.nexus.proxy.maven.maven2.M2RepositoryConfiguration;
import org.sonatype.nexus.proxy.repository.LocalStatus;
import org.sonatype.nexus.proxy.storage.remote.RemoteProviderHintFactory;
import org.sonatype.nexus.rest.model.RepositoryBaseResource;
import org.sonatype.nexus.rest.model.RepositoryListResourceResponse;
import org.sonatype.nexus.rest.model.RepositoryProxyResource;
import org.sonatype.nexus.rest.model.RepositoryResource;
import org.sonatype.nexus.rest.model.RepositoryResourceRemoteStorage;
import org.sonatype.nexus.rest.model.RepositoryResourceResponse;
import org.sonatype.nexus.rest.model.RepositoryShadowResource;
import org.sonatype.nexus.rest.repositories.AbstractRepositoryPlexusResource;
import org.sonatype.nexus.rest.util.EnumUtil;
import org.sonatype.nexus.templates.repository.DefaultRepositoryTemplateProvider;
import org.sonatype.nexus.templates.repository.ManuallyConfiguredRepositoryTemplate;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResourceException;

@Named
@Singleton
@Path(value="/repositories")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
public class RepositoryListPlexusResource
extends AbstractRepositoryPlexusResource {
    public static final String RESOURCE_URI = "/repositories";
    private final RemoteProviderHintFactory remoteProviderHintFactory;
    private final DefaultRepositoryTemplateProvider repositoryTemplateProvider;

    @Inject
    public RepositoryListPlexusResource(RemoteProviderHintFactory remoteProviderHintFactory, DefaultRepositoryTemplateProvider repositoryTemplateProvider) {
        this.remoteProviderHintFactory = remoteProviderHintFactory;
        this.repositoryTemplateProvider = repositoryTemplateProvider;
        this.setModifiable(true);
    }

    public Object getPayloadInstance() {
        return new RepositoryResourceResponse();
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor(this.getResourceUri(), "authcBasic,perms[nexus:repositories]");
    }

    @GET
    @ResourceMethodSignature(output=RepositoryListResourceResponse.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        return this.listRepositories(request, false, false);
    }

    @POST
    @ResourceMethodSignature(input=RepositoryResourceResponse.class, output=RepositoryResourceResponse.class)
    public Object post(Context context, Request request, Response response, Object payload) throws ResourceException {
        RepositoryResourceResponse repoRequest = (RepositoryResourceResponse)payload;
        String repoId = null;
        if (repoRequest != null) {
            RepositoryBaseResource resource = repoRequest.getData();
            repoId = resource.getId();
            try {
                CRepository config = this.getRepositoryAppModel(resource, null);
                ManuallyConfiguredRepositoryTemplate template = this.repositoryTemplateProvider.createManuallyTemplate(new CRepositoryCoreConfiguration(this.repositoryTemplateProvider.getApplicationConfiguration(), config, null));
                template.create();
                this.getNexusConfiguration().saveConfiguration();
            }
            catch (ConfigurationException e) {
                this.handleConfigurationException(e);
            }
            catch (IOException e) {
                this.getLogger().warn("Got IO Exception!", (Throwable)e);
                throw new ResourceException(Status.SERVER_ERROR_INTERNAL);
            }
        }
        return this.getRepositoryResourceResponse(request, repoId);
    }

    public CRepository getRepositoryAppModel(RepositoryBaseResource resource, CRepository target) throws ResourceException {
        DefaultCRepository appModel = new DefaultCRepository();
        Xpp3Dom ex = null;
        appModel.setLocalStatus(LocalStatus.IN_SERVICE.name());
        if (target != null) {
            appModel.setLocalStatus(target.getLocalStatus());
            ex = (Xpp3Dom)target.getExternalConfiguration();
        } else {
            ex = new Xpp3Dom("externalConfiguration");
        }
        appModel.setId(resource.getId());
        appModel.setName(resource.getName());
        appModel.setExposed(resource.isExposed());
        appModel.setProviderRole(resource.getProviderRole());
        if ("virtual".equals(resource.getRepoType())) {
            appModel.setExternalConfiguration((Object)ex);
            appModel.setIndexable(false);
            RepositoryShadowResource repoResource = (RepositoryShadowResource)resource;
            M2LayoutedM1ShadowRepositoryConfiguration exConf = new M2LayoutedM1ShadowRepositoryConfiguration(ex);
            exConf.setMasterRepositoryId(repoResource.getShadowOf());
            exConf.setSynchronizeAtStartup(repoResource.isSyncAtStartup());
        } else if (!"group".equals(resource.getRepoType())) {
            RepositoryResource repoResource = (RepositoryResource)resource;
            if (StringUtils.isNotEmpty((String)repoResource.getWritePolicy())) {
                appModel.setWritePolicy(repoResource.getWritePolicy());
            }
            appModel.setBrowseable(repoResource.isBrowseable());
            appModel.setIndexable(repoResource.isIndexable());
            appModel.setSearchable(repoResource.isIndexable());
            appModel.setNotFoundCacheTTL(repoResource.getNotFoundCacheTTL());
            appModel.setExternalConfiguration((Object)ex);
            M2RepositoryConfiguration exConf = new M2RepositoryConfiguration(ex);
            exConf.setRepositoryPolicy(EnumUtil.valueOf(repoResource.getRepoPolicy(), RepositoryPolicy.class));
            if (repoResource.getOverrideLocalStorageUrl() != null) {
                appModel.setLocalStorage(new CLocalStorage());
                appModel.getLocalStorage().setUrl(repoResource.getOverrideLocalStorageUrl());
                appModel.getLocalStorage().setProvider("file");
            } else {
                appModel.setLocalStorage(null);
            }
            RepositoryResourceRemoteStorage remoteStorage = repoResource.getRemoteStorage();
            if (remoteStorage != null) {
                appModel.setNotFoundCacheActive(true);
                appModel.setRemoteStorage(new CRemoteStorage());
                appModel.getRemoteStorage().setUrl(remoteStorage.getRemoteStorageUrl());
                appModel.getRemoteStorage().setProvider(this.remoteProviderHintFactory.getDefaultRoleHint(remoteStorage.getRemoteStorageUrl()));
            }
        }
        appModel.setProviderHint(resource.getProvider());
        if (RepositoryProxyResource.class.isAssignableFrom(resource.getClass())) {
            appModel = this.getRepositoryProxyAppModel((RepositoryProxyResource)resource, (CRepository)appModel);
        }
        return appModel;
    }

    public CRepository getRepositoryProxyAppModel(RepositoryProxyResource model, CRepository target) throws PlexusResourceException {
        M2RepositoryConfiguration exConf = new M2RepositoryConfiguration((Xpp3Dom)target.getExternalConfiguration());
        if (model.getProvider().equals("maven2") || model.getProvider().equals("maven1")) {
            exConf.setChecksumPolicy(EnumUtil.valueOf(model.getChecksumPolicy(), ChecksumPolicy.class));
        }
        exConf.setFileTypeValidation(model.isFileTypeValidation());
        exConf.setDownloadRemoteIndex(model.isDownloadRemoteIndexes());
        exConf.setArtifactMaxAge(model.getArtifactMaxAge());
        exConf.setMetadataMaxAge(model.getMetadataMaxAge());
        if (model.getItemMaxAge() != null) {
            exConf.setItemMaxAge(model.getItemMaxAge().intValue());
        }
        exConf.setAutoBlockActive(model.isAutoBlockActive());
        if (model.getRemoteStorage() != null) {
            if (target.getRemoteStorage() == null) {
                target.setRemoteStorage(new CRemoteStorage());
            }
            target.getRemoteStorage().setUrl(model.getRemoteStorage().getRemoteStorageUrl());
            target.getRemoteStorage().setAuthentication(this.convertAuthentication(model.getRemoteStorage().getAuthentication(), null));
            target.getRemoteStorage().setConnectionSettings(this.convertRemoteConnectionSettings(model.getRemoteStorage().getConnectionSettings()));
        }
        return target;
    }
}

