/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.repositories;

import javax.inject.Named;
import javax.inject.Singleton;
import org.restlet.data.Request;
import org.restlet.resource.ResourceException;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.ResourceStore;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.rest.AbstractResourceStoreContentPlexusResource;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;

@Named
@Singleton
public class RepositoryContentPlexusResource
extends AbstractResourceStoreContentPlexusResource {
    private static final String USE_WELCOME_FILES = "useWelcomeFiles";

    public RepositoryContentPlexusResource() {
        this.setModifiable(true);
        this.setRequireStrictChecking(false);
    }

    public Object getPayloadInstance() {
        return null;
    }

    public String getResourceUri() {
        return "/repositories/{repositoryId}/content";
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/repositories/*/content/**", "authcBasic,trperms");
    }

    @Override
    public boolean acceptsUpload() {
        return true;
    }

    @Override
    protected ResourceStore getResourceStore(Request request) throws NoSuchRepositoryException, ResourceException {
        return this.getUnprotectedRepositoryRegistry().getRepository(request.getAttributes().get("repositoryId").toString());
    }

    @Override
    protected ResourceStoreRequest getResourceStoreRequest(Request request, String resourceStorePath) {
        ResourceStoreRequest resourceStoreRequest = super.getResourceStoreRequest(request, resourceStorePath);
        resourceStoreRequest.getRequestContext().put(USE_WELCOME_FILES, (Object)Boolean.FALSE);
        return resourceStoreRequest;
    }
}

