/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.repositories;

import java.lang.reflect.Method;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.restlet.data.Form;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.configuration.application.AuthenticationInfoConverter;
import org.sonatype.nexus.configuration.application.GlobalRemoteConnectionSettings;
import org.sonatype.nexus.configuration.model.CRemoteAuthentication;
import org.sonatype.nexus.configuration.model.CRemoteConnectionSettings;
import org.sonatype.nexus.configuration.model.CRepository;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.maven.ChecksumPolicy;
import org.sonatype.nexus.proxy.maven.MavenProxyRepository;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.maven.RepositoryPolicy;
import org.sonatype.nexus.proxy.repository.AbstractRepository;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.HostedRepository;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.nexus.proxy.repository.RemoteStatus;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.repository.ShadowRepository;
import org.sonatype.nexus.rest.AbstractNexusPlexusResource;
import org.sonatype.nexus.rest.NexusCompat;
import org.sonatype.nexus.rest.NoSuchRepositoryAccessException;
import org.sonatype.nexus.rest.RepositoryURLBuilder;
import org.sonatype.nexus.rest.global.AbstractGlobalConfigurationPlexusResource;
import org.sonatype.nexus.rest.model.AuthenticationSettings;
import org.sonatype.nexus.rest.model.RemoteConnectionSettings;
import org.sonatype.nexus.rest.model.RepositoryBaseResource;
import org.sonatype.nexus.rest.model.RepositoryListResource;
import org.sonatype.nexus.rest.model.RepositoryListResourceResponse;
import org.sonatype.nexus.rest.model.RepositoryProxyResource;
import org.sonatype.nexus.rest.model.RepositoryResource;
import org.sonatype.nexus.rest.model.RepositoryResourceRemoteStorage;
import org.sonatype.nexus.rest.model.RepositoryResourceResponse;
import org.sonatype.nexus.rest.model.RepositoryShadowResource;

public abstract class AbstractRepositoryPlexusResource
extends AbstractNexusPlexusResource {
    public static final String REPOSITORY_ID_KEY = "repositoryId";
    private AuthenticationInfoConverter authenticationInfoConverter;
    private GlobalRemoteConnectionSettings globalRemoteConnectionSettings;
    private ApplicationConfiguration applicationConfiguration;
    private RepositoryURLBuilder repositoryURLBuilder;

    @Inject
    public void setAuthenticationInfoConverter(AuthenticationInfoConverter authenticationInfoConverter) {
        this.authenticationInfoConverter = authenticationInfoConverter;
    }

    @Inject
    public void setGlobalRemoteConnectionSettings(GlobalRemoteConnectionSettings globalRemoteConnectionSettings) {
        this.globalRemoteConnectionSettings = globalRemoteConnectionSettings;
    }

    @Inject
    public void setApplicationConfiguration(ApplicationConfiguration applicationConfiguration) {
        this.applicationConfiguration = applicationConfiguration;
    }

    @Inject
    public void setRepositoryURLBuilder(RepositoryURLBuilder repositoryURLBuilder) {
        this.repositoryURLBuilder = repositoryURLBuilder;
    }

    protected AuthenticationInfoConverter getAuthenticationInfoConverter() {
        return this.authenticationInfoConverter;
    }

    protected GlobalRemoteConnectionSettings getGlobalRemoteConnectionSettings() {
        return this.globalRemoteConnectionSettings;
    }

    protected ApplicationConfiguration getApplicationConfiguration() {
        return this.applicationConfiguration;
    }

    protected String getRepositoryId(Request request) {
        return request.getAttributes().get(REPOSITORY_ID_KEY).toString();
    }

    public String getRestRepoRemoteStatus(ProxyRepository repository, Request request, Response response) throws ResourceException {
        Form form = request.getResourceRef().getQueryAsForm();
        boolean forceCheck = form.getFirst("forceCheck") != null;
        RemoteStatus rs = repository.getRemoteStatus(new ResourceStoreRequest("/"), forceCheck);
        if (RemoteStatus.UNKNOWN.equals((Object)rs)) {
            response.setStatus(Status.SUCCESS_ACCEPTED);
        }
        return rs == null ? null : rs.toString() + (rs.getReason() == null ? "" : ":" + rs.getReason());
    }

    public String getRestRepoType(Repository repository) {
        if (repository.getRepositoryKind().isFacetAvailable(ProxyRepository.class)) {
            return "proxy";
        }
        if (repository.getRepositoryKind().isFacetAvailable(HostedRepository.class)) {
            return "hosted";
        }
        if (repository.getRepositoryKind().isFacetAvailable(ShadowRepository.class)) {
            return "virtual";
        }
        if (repository.getRepositoryKind().isFacetAvailable(GroupRepository.class)) {
            return "group";
        }
        throw new IllegalArgumentException("The passed model with class" + repository.getClass().getName() + " is not recognized!");
    }

    protected RepositoryListResourceResponse listRepositories(Request request, boolean allReposes) throws ResourceException {
        return this.listRepositories(request, allReposes, true);
    }

    protected RepositoryListResourceResponse listRepositories(Request request, boolean allReposes, boolean includeGroups) throws ResourceException {
        RepositoryListResourceResponse result = new RepositoryListResourceResponse();
        List repositories = this.getRepositoryRegistry().getRepositories();
        for (Repository repository : repositories) {
            if (!allReposes && !repository.isUserManaged() || !includeGroups && repository.getRepositoryKind().isFacetAvailable(GroupRepository.class)) continue;
            RepositoryListResource repoRes = new RepositoryListResource();
            repoRes.setResourceURI(this.createRepositoryReference(request, repository.getId()).toString());
            repoRes.setContentResourceURI(this.repositoryURLBuilder.getExposedRepositoryContentUrl(repository));
            repoRes.setRepoType(this.getRestRepoType(repository));
            repoRes.setProvider(NexusCompat.getRepositoryProviderHint(repository));
            repoRes.setProviderRole(NexusCompat.getRepositoryProviderRole(repository));
            repoRes.setFormat(repository.getRepositoryContentClass().getId());
            repoRes.setId(repository.getId());
            repoRes.setName(repository.getName());
            repoRes.setUserManaged(repository.isUserManaged());
            repoRes.setExposed(repository.isExposed());
            repoRes.setEffectiveLocalStorageUrl(repository.getLocalUrl());
            if (repository.getRepositoryKind().isFacetAvailable(MavenRepository.class)) {
                repoRes.setRepoPolicy(((MavenRepository)repository.adaptToFacet(MavenRepository.class)).getRepositoryPolicy().toString());
            }
            if (repository.getRepositoryKind().isFacetAvailable(ProxyRepository.class)) {
                repoRes.setRemoteUri(((ProxyRepository)repository.adaptToFacet(ProxyRepository.class)).getRemoteUrl());
            }
            result.addData(repoRes);
        }
        return result;
    }

    protected RepositoryResourceResponse getRepositoryResourceResponse(Request request, String repoId) throws ResourceException {
        RepositoryResourceResponse result = new RepositoryResourceResponse();
        try {
            RepositoryBaseResource resource = null;
            Repository repository = this.getRepositoryRegistry().getRepository(repoId);
            if (repository.getRepositoryKind().isFacetAvailable(GroupRepository.class)) {
                throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "Repository Not Found");
            }
            resource = this.getRepositoryRestModel(request, repository);
            result.setData(resource);
        }
        catch (NoSuchRepositoryAccessException e) {
            this.getLogger().warn("Repository access denied, id=" + repoId);
            throw new ResourceException(Status.CLIENT_ERROR_FORBIDDEN, "Access Denied to Repository");
        }
        catch (NoSuchRepositoryException e) {
            this.getLogger().warn("Repository not found, id=" + repoId);
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "Repository Not Found");
        }
        return result;
    }

    public RepositoryBaseResource getRepositoryRestModel(Request request, Repository repository) {
        RepositoryProxyResource resource = null;
        if (repository.getRepositoryKind().isFacetAvailable(ProxyRepository.class)) {
            resource = this.getRepositoryProxyRestModel((ProxyRepository)repository.adaptToFacet(ProxyRepository.class));
        } else {
            if (repository.getRepositoryKind().isFacetAvailable(ShadowRepository.class)) {
                return this.getRepositoryShadowRestModel(request, (ShadowRepository)repository.adaptToFacet(ShadowRepository.class));
            }
            resource = new RepositoryResource();
        }
        resource.setContentResourceURI(this.repositoryURLBuilder.getExposedRepositoryContentUrl(repository));
        resource.setProvider(NexusCompat.getRepositoryProviderHint(repository));
        resource.setProviderRole(NexusCompat.getRepositoryProviderRole(repository));
        resource.setFormat(repository.getRepositoryContentClass().getId());
        resource.setRepoType(this.getRestRepoType(repository));
        resource.setId(repository.getId());
        resource.setName(repository.getName());
        resource.setWritePolicy(repository.getWritePolicy().name());
        resource.setBrowseable(repository.isBrowseable());
        resource.setIndexable(repository.isSearchable());
        resource.setExposed(repository.isExposed());
        resource.setNotFoundCacheTTL(repository.getNotFoundCacheTimeToLive());
        String defaultLocalStorageUrl = ((CRepository)((AbstractRepository)repository).getCurrentCoreConfiguration().getConfiguration((boolean)false)).defaultLocalStorageUrl;
        resource.setDefaultLocalStorageUrl(defaultLocalStorageUrl);
        String overrideLocalStorageUrl = ((CRepository)((AbstractRepository)repository).getCurrentCoreConfiguration().getConfiguration(false)).getLocalStorage().getUrl();
        if (StringUtils.isNotBlank((String)overrideLocalStorageUrl)) {
            resource.setOverrideLocalStorageUrl(overrideLocalStorageUrl);
        }
        if (repository.getRepositoryKind().isFacetAvailable(MavenRepository.class)) {
            resource.setRepoPolicy(((MavenRepository)repository.adaptToFacet(MavenRepository.class)).getRepositoryPolicy().toString());
            if (repository.getRepositoryKind().isFacetAvailable(MavenProxyRepository.class)) {
                resource.setChecksumPolicy(((MavenProxyRepository)repository.adaptToFacet(MavenProxyRepository.class)).getChecksumPolicy().toString());
                resource.setDownloadRemoteIndexes(((MavenProxyRepository)repository.adaptToFacet(MavenProxyRepository.class)).isDownloadRemoteIndexes());
            }
        } else {
            resource.setRepoPolicy(RepositoryPolicy.MIXED.name());
            resource.setChecksumPolicy(ChecksumPolicy.IGNORE.name());
            resource.setDownloadRemoteIndexes(false);
        }
        return resource;
    }

    public RepositoryProxyResource getRepositoryProxyRestModel(ProxyRepository repository) {
        RepositoryProxyResource resource = new RepositoryProxyResource();
        resource.setRemoteStorage(new RepositoryResourceRemoteStorage());
        resource.getRemoteStorage().setRemoteStorageUrl(repository.getRemoteUrl());
        resource.getRemoteStorage().setAuthentication(AbstractGlobalConfigurationPlexusResource.convert(NexusCompat.getRepositoryRawConfiguration((Repository)repository).getRemoteStorage().getAuthentication()));
        resource.getRemoteStorage().setConnectionSettings(AbstractGlobalConfigurationPlexusResource.convert(NexusCompat.getRepositoryRawConfiguration((Repository)repository).getRemoteStorage().getConnectionSettings()));
        resource.setAutoBlockActive(repository.isAutoBlockActive());
        resource.setFileTypeValidation(repository.isFileTypeValidation());
        if (repository.getRepositoryKind().isFacetAvailable(MavenProxyRepository.class)) {
            resource.setArtifactMaxAge(((MavenProxyRepository)repository.adaptToFacet(MavenProxyRepository.class)).getArtifactMaxAge());
            resource.setMetadataMaxAge(((MavenProxyRepository)repository.adaptToFacet(MavenProxyRepository.class)).getMetadataMaxAge());
            resource.setItemMaxAge(Integer.valueOf(((MavenProxyRepository)repository.adaptToFacet(MavenProxyRepository.class)).getItemMaxAge()));
        } else {
            try {
                Method metadataMethod;
                Method artifactMethod;
                Method itemMethod = repository.getClass().getMethod("getItemMaxAge", new Class[0]);
                if (itemMethod != null) {
                    resource.setItemMaxAge((Integer)itemMethod.invoke((Object)repository, new Object[0]));
                }
                if ((artifactMethod = repository.getClass().getMethod("getArtifactMaxAge", new Class[0])) != null) {
                    resource.setArtifactMaxAge(((Integer)artifactMethod.invoke((Object)repository, new Object[0])).intValue());
                }
                if ((metadataMethod = repository.getClass().getMethod("getMetadataMaxAge", new Class[0])) != null) {
                    resource.setMetadataMaxAge(((Integer)metadataMethod.invoke((Object)repository, new Object[0])).intValue());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return resource;
    }

    public RepositoryShadowResource getRepositoryShadowRestModel(Request request, ShadowRepository shadow) {
        RepositoryShadowResource resource = new RepositoryShadowResource();
        resource.setId(shadow.getId());
        resource.setName(shadow.getName());
        resource.setContentResourceURI(this.repositoryURLBuilder.getExposedRepositoryContentUrl((Repository)shadow));
        resource.setProvider(NexusCompat.getRepositoryProviderHint((Repository)shadow));
        resource.setRepoType("virtual");
        resource.setFormat(shadow.getRepositoryContentClass().getId());
        resource.setShadowOf(shadow.getMasterRepository().getId());
        resource.setSyncAtStartup(shadow.isSynchronizeAtStartup());
        resource.setExposed(shadow.isExposed());
        return resource;
    }

    protected CRemoteAuthentication convertAuthentication(AuthenticationSettings authentication, String oldPassword) {
        if (authentication == null) {
            return null;
        }
        CRemoteAuthentication appModelSettings = new CRemoteAuthentication();
        appModelSettings.setUsername(authentication.getUsername());
        appModelSettings.setPassword(this.getActualPassword(authentication.getPassword(), oldPassword));
        appModelSettings.setNtlmDomain(authentication.getNtlmDomain());
        appModelSettings.setNtlmHost(authentication.getNtlmHost());
        return appModelSettings;
    }

    protected CRemoteConnectionSettings convertRemoteConnectionSettings(RemoteConnectionSettings remoteConnectionSettings) {
        if (remoteConnectionSettings == null) {
            return null;
        }
        CRemoteConnectionSettings cRemoteConnectionSettings = new CRemoteConnectionSettings();
        cRemoteConnectionSettings.setConnectionTimeout(remoteConnectionSettings.getConnectionTimeout() * 1000);
        cRemoteConnectionSettings.setQueryString(remoteConnectionSettings.getQueryString());
        cRemoteConnectionSettings.setRetrievalRetryCount(remoteConnectionSettings.getRetrievalRetryCount());
        cRemoteConnectionSettings.setUserAgentCustomizationString(remoteConnectionSettings.getUserAgentString());
        return cRemoteConnectionSettings;
    }
}

