/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.privileges;

import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.nexus.rest.model.PrivilegeResource;
import org.sonatype.nexus.rest.model.PrivilegeResourceRequest;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResourceException;
import org.sonatype.security.authorization.NoSuchAuthorizationManagerException;
import org.sonatype.security.authorization.Privilege;
import org.sonatype.security.rest.model.PrivilegeListResourceResponse;
import org.sonatype.security.rest.privileges.AbstractPrivilegePlexusResource;

@Named
@Singleton
@Path(value="/privileges_target")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
public class TargetPrivilegePlexusResource
extends AbstractPrivilegePlexusResource {
    public static final String RESOURCE_URI = "/privileges_target";

    public TargetPrivilegePlexusResource() {
        this.setModifiable(true);
    }

    public Object getPayloadInstance() {
        return new PrivilegeResourceRequest();
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor(this.getResourceUri(), "authcBasic,perms[security:privileges]");
    }

    @POST
    @ResourceMethodSignature(input=PrivilegeResourceRequest.class, output=PrivilegeListResourceResponse.class)
    public Object post(Context context, Request request, Response response, Object payload) throws ResourceException {
        PrivilegeResourceRequest resourceRequest = (PrivilegeResourceRequest)payload;
        PrivilegeListResourceResponse result = null;
        if (resourceRequest != null) {
            result = new PrivilegeListResourceResponse();
            PrivilegeResource resource = resourceRequest.getData();
            if (!"target".equals(resource.getType())) {
                throw new PlexusResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Configuration error.", (Object)this.getErrorResponse("type", "Not allowed privilege type!"));
            }
            List methods = resource.getMethod();
            if (methods == null || methods.size() == 0) {
                throw new PlexusResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Configuration error.", (Object)this.getErrorResponse("method", "No method(s) supplied, must select at least one method."));
            }
            try {
                for (String method : methods) {
                    Privilege priv = new Privilege();
                    priv.setName(resource.getName() != null ? resource.getName() + " - (" + method + ")" : null);
                    priv.setDescription(resource.getDescription());
                    priv.setType("target");
                    priv.addProperty("method", method);
                    priv.addProperty("repositoryTargetId", resource.getRepositoryTargetId());
                    priv.addProperty("repositoryId", resource.getRepositoryId());
                    priv.addProperty("repositoryGroupId", resource.getRepositoryGroupId());
                    priv = this.getSecuritySystem().getAuthorizationManager("default").addPrivilege(priv);
                    result.addData(this.securityToRestModel(priv, request, true));
                }
            }
            catch (InvalidConfigurationException e) {
                this.handleInvalidConfigurationException(e);
            }
            catch (NoSuchAuthorizationManagerException e) {
                this.getLogger().warn("Could not find the default AuthorizationManager", (Throwable)e);
                throw new ResourceException(Status.SERVER_ERROR_INTERNAL, (Throwable)e);
            }
        }
        return result;
    }
}

