/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.mirrors;

import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.repositories.metadata.NexusRepositoryMetadataHandler;
import org.sonatype.nexus.repository.metadata.MetadataHandlerException;
import org.sonatype.nexus.repository.metadata.model.RepositoryMetadata;
import org.sonatype.nexus.repository.metadata.model.RepositoryMirrorMetadata;
import org.sonatype.nexus.rest.mirrors.AbstractRepositoryMirrorPlexusResource;
import org.sonatype.nexus.rest.model.MirrorResource;
import org.sonatype.nexus.rest.model.MirrorResourceListResponse;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;

@Named
@Singleton
@Path(value="/repository_predefined_mirrors/{repositoryId}")
@Consumes(value={"application/xml", "application/json"})
public class RepositoryPredefinedMirrorListPlexusResource
extends AbstractRepositoryMirrorPlexusResource {
    public static final String RESOURCE_URI = "/repository_predefined_mirrors/{repositoryId}";
    private final NexusRepositoryMetadataHandler repoMetadata;

    @Inject
    public RepositoryPredefinedMirrorListPlexusResource(NexusRepositoryMetadataHandler repoMetadata) {
        this.repoMetadata = repoMetadata;
        this.setModifiable(false);
    }

    public Object getPayloadInstance() {
        return null;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/repository_predefined_mirrors/*", "authcBasic,perms[nexus:repositorypredefinedmirrors]");
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    @GET
    @ResourceMethodSignature(pathParams={@PathParam(value="repositoryId")}, output=MirrorResourceListResponse.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        MirrorResourceListResponse dto = new MirrorResourceListResponse();
        String repositoryId = this.getRepositoryId(request);
        RepositoryMetadata metadata = this.getMetadata(repositoryId);
        if (metadata != null) {
            for (RepositoryMirrorMetadata mirror : metadata.getMirrors()) {
                MirrorResource resource = new MirrorResource();
                resource.setId(mirror.getId());
                resource.setUrl(mirror.getUrl());
                dto.addData(resource);
            }
        }
        return dto;
    }

    private RepositoryMetadata getMetadata(String repositoryId) throws ResourceException {
        RepositoryMetadata metadata = null;
        try {
            metadata = this.repoMetadata.readRepositoryMetadata(repositoryId);
        }
        catch (NoSuchRepositoryException e) {
            this.getLogger().error("Unable to retrieve metadata", (Throwable)e);
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Invalid repository ID", (Throwable)e);
        }
        catch (MetadataHandlerException e) {
            this.getLogger().info("Unable to retrieve metadata, returning no items: " + e.getMessage());
        }
        catch (IOException e) {
            this.getLogger().error("Unable to retrieve metadata", (Throwable)e);
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, "Metadata handling error", (Throwable)e);
        }
        return metadata;
    }
}

