/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.mirrors;

import java.io.IOException;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.repository.Mirror;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.rest.mirrors.AbstractRepositoryMirrorPlexusResource;
import org.sonatype.nexus.rest.model.MirrorResourceListRequest;
import org.sonatype.nexus.rest.model.MirrorResourceListResponse;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;

@Named
@Singleton
@Path(value="/repository_mirrors/{repositoryId}")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
public class RepositoryMirrorListPlexusResource
extends AbstractRepositoryMirrorPlexusResource {
    public static final String RESOURCE_URI = "/repository_mirrors/{repositoryId}";

    public RepositoryMirrorListPlexusResource() {
        this.setModifiable(true);
    }

    public Object getPayloadInstance() {
        return new MirrorResourceListRequest();
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/repository_mirrors/*", "authcBasic,perms[nexus:repositorymirrors]");
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    @GET
    @ResourceMethodSignature(pathParams={@PathParam(value="repositoryId")}, output=MirrorResourceListResponse.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        MirrorResourceListResponse dto = new MirrorResourceListResponse();
        dto.getData();
        try {
            Repository repository = this.getRepositoryRegistry().getRepository(this.getRepositoryId(request));
            for (Mirror mirror : this.getMirrors(repository)) {
                dto.addData(this.nexusToRestModel(mirror));
            }
        }
        catch (NoSuchRepositoryException e) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Invalid repository id " + this.getRepositoryId(request), (Throwable)e);
        }
        return dto;
    }

    @POST
    @ResourceMethodSignature(pathParams={@PathParam(value="repositoryId")}, input=MirrorResourceListRequest.class, output=MirrorResourceListResponse.class)
    public Object post(Context context, Request request, Response response, Object payload) throws ResourceException {
        MirrorResourceListResponse dto = new MirrorResourceListResponse();
        try {
            List resources = ((MirrorResourceListRequest)payload).getData();
            List<Mirror> mirrors = this.restToNexusModel(resources);
            Repository repository = this.getRepositoryRegistry().getRepository(this.getRepositoryId(request));
            this.setMirrors(repository, mirrors);
            dto.setData(this.nexusToRestModel(mirrors));
        }
        catch (NoSuchRepositoryException e) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Invalid repository id " + this.getRepositoryId(request), (Throwable)e);
        }
        catch (IOException e) {
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, "Unable to create mirror", (Throwable)e);
        }
        return dto;
    }
}

