/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.mirrors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.restlet.data.Request;
import org.sonatype.nexus.proxy.repository.Mirror;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.rest.AbstractNexusPlexusResource;
import org.sonatype.nexus.rest.model.MirrorResource;

public abstract class AbstractRepositoryMirrorPlexusResource
extends AbstractNexusPlexusResource {
    public static final String REPOSITORY_ID_KEY = "repositoryId";
    public static final String MIRROR_ID_KEY = "mirrorId";

    protected String getRepositoryId(Request request) {
        return request.getAttributes().get(REPOSITORY_ID_KEY).toString();
    }

    protected String getMirrorId(Request request) {
        return request.getAttributes().get(MIRROR_ID_KEY).toString();
    }

    protected List<MirrorResource> nexusToRestModel(List<Mirror> mirrors) {
        ArrayList<MirrorResource> sortedList = new ArrayList<MirrorResource>();
        for (Mirror mirror : mirrors) {
            sortedList.add(this.nexusToRestModel(mirror));
        }
        return sortedList;
    }

    protected MirrorResource nexusToRestModel(Mirror mirror) {
        MirrorResource resource = new MirrorResource();
        resource.setId(mirror.getId());
        resource.setUrl(mirror.getUrl());
        return resource;
    }

    protected List<Mirror> restToNexusModel(List<MirrorResource> resources) {
        ArrayList<Mirror> sortedList = new ArrayList<Mirror>();
        for (MirrorResource resource : resources) {
            sortedList.add(this.restToNexusModel(resource));
        }
        return sortedList;
    }

    protected Mirror restToNexusModel(MirrorResource resource) {
        Mirror mirror = new Mirror(resource.getId(), resource.getUrl());
        return mirror;
    }

    protected List<Mirror> getMirrors(Repository repository) {
        return repository.getPublishedMirrors().getMirrors();
    }

    protected void setMirrors(Repository repository, List<Mirror> mirrors) throws IOException {
        for (Mirror mirror : mirrors) {
            if (!StringUtils.isEmpty((String)mirror.getId())) continue;
            mirror.setId(mirror.getUrl());
        }
        repository.getPublishedMirrors().setMirrors(mirrors);
        this.getNexusConfiguration().saveConfiguration();
    }
}

