/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.groups;

import java.io.IOException;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.lang.StringUtils;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.nexus.proxy.AccessDeniedException;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.rest.NoSuchRepositoryAccessException;
import org.sonatype.nexus.rest.groups.AbstractRepositoryGroupPlexusResource;
import org.sonatype.nexus.rest.model.RepositoryGroupResource;
import org.sonatype.nexus.rest.model.RepositoryGroupResourceResponse;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResourceException;

@Named
@Singleton
@Path(value="/repo_groups/{groupId}")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
public class RepositoryGroupPlexusResource
extends AbstractRepositoryGroupPlexusResource {
    public static final String RESOURCE_URI = "/repo_groups/{groupId}";

    public RepositoryGroupPlexusResource() {
        this.setModifiable(true);
    }

    public Object getPayloadInstance() {
        return new RepositoryGroupResourceResponse();
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/repo_groups/*", "authcBasic,perms[nexus:repogroups]");
    }

    protected String getGroupId(Request request) {
        return request.getAttributes().get("groupId").toString();
    }

    @GET
    @ResourceMethodSignature(pathParams={@PathParam(value="groupId")}, output=RepositoryGroupResourceResponse.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        RepositoryGroupResourceResponse result = new RepositoryGroupResourceResponse();
        GroupRepository groupRepo = null;
        try {
            groupRepo = (GroupRepository)this.getRepositoryRegistry().getRepositoryWithFacet(this.getGroupId(request), GroupRepository.class);
            result.setData(this.buildGroupResource(request, groupRepo));
        }
        catch (NoSuchRepositoryAccessException e) {
            this.getLogger().debug("Blocking access to all repository groups, based on permissions.");
            throw new ResourceException(Status.CLIENT_ERROR_FORBIDDEN, "Access Denied to Repository Group");
        }
        catch (NoSuchRepositoryException e) {
            this.getLogger().warn("Repository Group not found, id=" + this.getGroupId(request));
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Cause by: ", (Throwable)e);
            }
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "Repository Group Not Found");
        }
        return result;
    }

    @PUT
    @ResourceMethodSignature(pathParams={@PathParam(value="groupId")}, input=RepositoryGroupResourceResponse.class, output=RepositoryGroupResourceResponse.class)
    public Object put(Context context, Request request, Response response, Object payload) throws ResourceException {
        RepositoryGroupResourceResponse groupRequest = (RepositoryGroupResourceResponse)payload;
        RepositoryGroupResourceResponse result = new RepositoryGroupResourceResponse();
        if (groupRequest != null) {
            RepositoryGroupResource resource = groupRequest.getData();
            if (StringUtils.isEmpty((String)resource.getId())) {
                this.getLogger().warn("Repository group id is empty! ");
                throw new PlexusResourceException(Status.CLIENT_ERROR_NOT_FOUND, "Repository group id is empty! ", (Object)this.getNexusErrorResponse("repositories", "Repository group id can't be empty! "));
            }
            this.createOrUpdateRepositoryGroup(resource, false);
            try {
                result.setData(this.buildGroupResource(request, groupRequest.getData().getId()));
            }
            catch (NoSuchRepositoryException e) {
                throw new PlexusResourceException(Status.CLIENT_ERROR_NOT_FOUND, "Repository group id is somehow invalid! ", (Object)this.getNexusErrorResponse("repositories", "Repository group id is invalid! "));
            }
        }
        return result;
    }

    @DELETE
    @ResourceMethodSignature(pathParams={@PathParam(value="groupId")})
    public void delete(Context context, Request request, Response response) throws ResourceException {
        try {
            this.getRepositoryRegistry().getRepositoryWithFacet(this.getGroupId(request), GroupRepository.class);
            this.getNexusConfiguration().deleteRepository(this.getGroupId(request));
        }
        catch (NoSuchRepositoryAccessException e) {
            this.getLogger().warn("Repository group Access Denied, id=" + this.getGroupId(request));
            throw new ResourceException(Status.CLIENT_ERROR_FORBIDDEN, "Access Denied to Repository Group");
        }
        catch (NoSuchRepositoryException e) {
            this.getLogger().warn("Repository group not found, id=" + this.getGroupId(request));
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "Repository Group Not Found");
        }
        catch (ConfigurationException e) {
            this.getLogger().warn("Repository group cannot be deleted, it has dependants, id=" + this.getGroupId(request));
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Repository Group Cannot be deleted");
        }
        catch (IOException e) {
            this.getLogger().warn("Got IO Exception!", (Throwable)e);
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL);
        }
        catch (AccessDeniedException e) {
            this.getLogger().warn("Not allowed to delete Repository Group '" + this.getGroupId(request) + "'", (Throwable)e);
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Not allowed to delete Repository Group '" + this.getGroupId(request) + "'");
        }
    }
}

