/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.groups;

import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.rest.NoSuchRepositoryAccessException;
import org.sonatype.nexus.rest.groups.AbstractRepositoryGroupPlexusResource;
import org.sonatype.nexus.rest.model.RepositoryGroupListResource;
import org.sonatype.nexus.rest.model.RepositoryGroupListResourceResponse;
import org.sonatype.nexus.rest.model.RepositoryGroupResource;
import org.sonatype.nexus.rest.model.RepositoryGroupResourceResponse;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResourceException;

@Named
@Singleton
@Path(value="/repo_groups")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
public class RepositoryGroupListPlexusResource
extends AbstractRepositoryGroupPlexusResource {
    public static final String RESOURCE_URI = "/repo_groups";

    public RepositoryGroupListPlexusResource() {
        this.setModifiable(true);
    }

    public Object getPayloadInstance() {
        return new RepositoryGroupResourceResponse();
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor(this.getResourceUri(), "authcBasic,perms[nexus:repogroups]");
    }

    @GET
    @ResourceMethodSignature(output=RepositoryGroupListResourceResponse.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        RepositoryGroupListResourceResponse result = new RepositoryGroupListResourceResponse();
        List groups = this.getRepositoryRegistry().getRepositoriesWithFacet(GroupRepository.class);
        try {
            for (GroupRepository group : groups) {
                RepositoryGroupListResource resource = new RepositoryGroupListResource();
                resource.setContentResourceURI(this.getRepositoryURLBuilder().getExposedRepositoryContentUrl((Repository)group));
                resource.setResourceURI(this.createRepositoryGroupReference(request, group.getId()).toString());
                resource.setId(group.getId());
                resource.setExposed(group.isExposed());
                resource.setUserManaged(group.isUserManaged());
                resource.setFormat(((GroupRepository)this.getRepositoryRegistry().getRepositoryWithFacet(group.getId(), GroupRepository.class)).getRepositoryContentClass().getId());
                resource.setName(group.getName());
                result.addData(resource);
            }
        }
        catch (NoSuchRepositoryAccessException e) {
            this.getLogger().debug("Blocking access to all repository groups, based on permissions.");
            throw new ResourceException(Status.CLIENT_ERROR_FORBIDDEN);
        }
        catch (NoSuchRepositoryException e) {
            this.getLogger().warn("Cannot find a repository group or repository declared within a group!", (Throwable)e);
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL);
        }
        return result;
    }

    @POST
    @ResourceMethodSignature(input=RepositoryGroupResourceResponse.class, output=RepositoryGroupResourceResponse.class)
    public Object post(Context context, Request request, Response response, Object payload) throws ResourceException {
        RepositoryGroupResourceResponse groupRequest = (RepositoryGroupResourceResponse)payload;
        if (groupRequest != null) {
            RepositoryGroupResource resource = groupRequest.getData();
            this.createOrUpdateRepositoryGroup(resource, true);
            try {
                RepositoryGroupResourceResponse result = new RepositoryGroupResourceResponse();
                result.setData(this.buildGroupResource(request, resource.getId()));
                return result;
            }
            catch (NoSuchRepositoryException e) {
                throw new PlexusResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "The group was somehow not found!", (Object)this.getNexusErrorResponse("repositories", "Group id not found!"));
            }
        }
        return null;
    }
}

