/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.groups;

import java.io.IOException;
import java.util.ArrayList;
import javax.inject.Inject;
import org.restlet.data.Request;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.registry.ContentClass;
import org.sonatype.nexus.proxy.registry.RepositoryTypeRegistry;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.InvalidGroupingException;
import org.sonatype.nexus.proxy.repository.LocalStatus;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.rest.AbstractNexusPlexusResource;
import org.sonatype.nexus.rest.NexusCompat;
import org.sonatype.nexus.rest.NoSuchRepositoryAccessException;
import org.sonatype.nexus.rest.RepositoryURLBuilder;
import org.sonatype.nexus.rest.model.RepositoryGroupMemberRepository;
import org.sonatype.nexus.rest.model.RepositoryGroupResource;
import org.sonatype.nexus.templates.repository.AbstractRepositoryTemplate;
import org.sonatype.nexus.templates.repository.RepositoryTemplate;
import org.sonatype.plexus.rest.resource.PlexusResourceException;

public abstract class AbstractRepositoryGroupPlexusResource
extends AbstractNexusPlexusResource {
    public static final String GROUP_ID_KEY = "groupId";
    private RepositoryTypeRegistry repositoryTypeRegistry;
    private RepositoryURLBuilder repositoryURLBuilder;

    @Inject
    public void setRepositoryTypeRegistry(RepositoryTypeRegistry repositoryTypeRegistry) {
        this.repositoryTypeRegistry = repositoryTypeRegistry;
    }

    @Inject
    public void setRepositoryURLBuilder(RepositoryURLBuilder repositoryURLBuilder) {
        this.repositoryURLBuilder = repositoryURLBuilder;
    }

    protected RepositoryURLBuilder getRepositoryURLBuilder() {
        return this.repositoryURLBuilder;
    }

    protected RepositoryGroupResource buildGroupResource(Request request, String groupId) throws NoSuchRepositoryException, ResourceException {
        Repository repo = this.getRepositoryRegistry().getRepository(groupId);
        if (repo.getRepositoryKind().isFacetAvailable(GroupRepository.class)) {
            return this.buildGroupResource(request, (GroupRepository)repo.adaptToFacet(GroupRepository.class));
        }
        return null;
    }

    protected RepositoryGroupResource buildGroupResource(Request request, GroupRepository group) throws ResourceException {
        RepositoryGroupResource resource = new RepositoryGroupResource();
        resource.setContentResourceURI(this.getRepositoryURLBuilder().getExposedRepositoryContentUrl((Repository)group));
        resource.setId(group.getId());
        resource.setName(group.getName());
        resource.setProvider(NexusCompat.getRepositoryProviderHint((Repository)group));
        resource.setRepoType("group");
        resource.setFormat(group.getRepositoryContentClass().getId());
        resource.setExposed(group.isExposed());
        resource.getRepositories();
        for (String repoId : group.getMemberRepositoryIds()) {
            RepositoryGroupMemberRepository member = new RepositoryGroupMemberRepository();
            member.setId(repoId);
            try {
                member.setName(this.getRepositoryRegistry().getRepository(repoId).getName());
            }
            catch (NoSuchRepositoryAccessException e) {
                this.getLogger().debug("Blocking access to repository group, based on permissions.");
                throw new ResourceException(Status.CLIENT_ERROR_FORBIDDEN);
            }
            catch (NoSuchRepositoryException e) {
                this.getLogger().debug("Found missing repo id: " + repoId + " contained in group");
            }
            member.setResourceURI(this.createChildReference(request, this, repoId).toString());
            resource.addRepository(member);
        }
        return resource;
    }

    protected void createOrUpdateRepositoryGroup(RepositoryGroupResource model, boolean create) throws ResourceException {
        if (create) {
            this.createRepositoryGroup(model);
        } else {
            this.updateRepositoryGroup(model);
        }
    }

    protected void updateRepositoryGroup(RepositoryGroupResource model) throws ResourceException {
        try {
            GroupRepository group = (GroupRepository)this.getRepositoryRegistry().getRepositoryWithFacet(model.getId(), GroupRepository.class);
            group.setName(model.getName());
            group.setExposed(model.isExposed());
            ArrayList<String> members = new ArrayList<String>();
            for (RepositoryGroupMemberRepository member : model.getRepositories()) {
                members.add(member.getId());
            }
            group.setMemberRepositoryIds(members);
            this.getNexusConfiguration().saveConfiguration();
        }
        catch (NoSuchRepositoryAccessException e) {
            this.getLogger().warn("Repository referenced by Repository Group Access Eenied, ID=" + model.getId(), (Throwable)((Object)e));
            throw new PlexusResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Repository referenced by Repository Group Access Denied, GroupId=" + model.getId(), (Throwable)((Object)e), (Object)this.getNexusErrorResponse("repositories", "Repository referenced by Repository Group Access Denied"));
        }
        catch (NoSuchRepositoryException e) {
            this.getLogger().warn("Repository referenced by Repository Group Not Found, ID=" + model.getId(), (Throwable)e);
            throw new PlexusResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Repository referenced by Repository Group Not Found, GroupId=" + model.getId(), (Throwable)e, (Object)this.getNexusErrorResponse("repositories", "Repository referenced by Repository Group Not Found"));
        }
        catch (InvalidGroupingException e) {
            this.getLogger().warn("Invalid grouping detected!, GroupId=" + model.getId(), (Throwable)e);
            throw new PlexusResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Invalid grouping requested, GroupId=" + model.getId(), (Throwable)e, (Object)this.getNexusErrorResponse("repositories", e.getMessage()));
        }
        catch (IOException e) {
            this.getLogger().warn("Got IO Exception!", (Throwable)e);
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, (Throwable)e);
        }
    }

    protected void createRepositoryGroup(RepositoryGroupResource model) throws ResourceException {
        try {
            ContentClass contentClass = this.repositoryTypeRegistry.getRepositoryContentClass(GroupRepository.class, model.getProvider());
            RepositoryTemplate template = (RepositoryTemplate)this.getRepositoryTemplates().getTemplates(new Object[]{GroupRepository.class, contentClass, new AbstractRepositoryTemplate.ProviderHint(model.getProvider())}).pick();
            template.getConfigurableRepository().setId(model.getId());
            template.getConfigurableRepository().setName(model.getName());
            template.getConfigurableRepository().setExposed(model.isExposed());
            template.getConfigurableRepository().setLocalStatus(LocalStatus.IN_SERVICE);
            GroupRepository groupRepository = (GroupRepository)template.create();
            ArrayList<String> memberIds = new ArrayList<String>(model.getRepositories().size());
            for (RepositoryGroupMemberRepository member : model.getRepositories()) {
                memberIds.add(member.getId());
            }
            groupRepository.setMemberRepositoryIds(memberIds);
            this.getNexusConfiguration().saveConfiguration();
        }
        catch (NoSuchRepositoryException e) {
            this.getLogger().warn("Repository referenced by group does not exists!, GroupId=" + model.getId(), (Throwable)e);
            throw new PlexusResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Repository referenced by group does not exists, GroupId=" + model.getId(), (Throwable)e, (Object)this.getNexusErrorResponse("repositories", "Repository referenced by Repository Group does not exists!"));
        }
        catch (InvalidGroupingException e) {
            this.getLogger().warn("Invalid grouping detected!, GroupId=" + model.getId(), (Throwable)e);
            throw new PlexusResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Invalid grouping requested, GroupId=" + model.getId(), (Throwable)e, (Object)this.getNexusErrorResponse("repositories", e.getMessage()));
        }
        catch (IOException e) {
            this.getLogger().warn("Got IO Exception!", (Throwable)e);
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, (Throwable)e);
        }
        catch (ConfigurationException e) {
            this.handleConfigurationException(e);
        }
    }
}

