/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.global;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import java.net.UnknownHostException;
import java.security.cert.CertPathBuilderException;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import org.apache.commons.lang.StringUtils;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.sonatype.nexus.configuration.model.CSmtpConfiguration;
import org.sonatype.nexus.email.EmailerException;
import org.sonatype.nexus.email.SmtpSettingsValidator;
import org.sonatype.nexus.rest.global.AbstractGlobalConfigurationPlexusResource;
import org.sonatype.nexus.rest.model.HtmlUnescapeStringConverter;
import org.sonatype.nexus.rest.model.SmtpSettingsResource;
import org.sonatype.nexus.rest.model.SmtpSettingsResourceRequest;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResourceException;

@Named
@Singleton
@Path(value="/check_smtp_settings")
@Consumes(value={"application/xml", "application/json"})
public class SmtpSettingsValidationPlexusResource
extends AbstractGlobalConfigurationPlexusResource {
    public static final String RESOURCE_URI = "/check_smtp_settings";
    private static final Pattern EMAIL_PATTERN = Pattern.compile(".+@.+\\.[a-zA-Z]+");
    private final SmtpSettingsValidator emailer;

    @Inject
    public SmtpSettingsValidationPlexusResource(SmtpSettingsValidator emailer) {
        this.emailer = emailer;
        this.setModifiable(true);
    }

    public Object getPayloadInstance() {
        return new SmtpSettingsResourceRequest();
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor(RESOURCE_URI, "authcBasic,perms[nexus:settings]");
    }

    @PUT
    @ResourceMethodSignature(input=SmtpSettingsResourceRequest.class)
    public Object put(Context context, Request request, Response response, Object payload) throws ResourceException {
        boolean status;
        SmtpSettingsResourceRequest configRequest = (SmtpSettingsResourceRequest)payload;
        SmtpSettingsResource settings = configRequest.getData();
        String email = settings.getTestEmail();
        SmtpSettingsValidationPlexusResource.validateEmail(email);
        CSmtpConfiguration config = new CSmtpConfiguration();
        config.setHostname(settings.getHost());
        String oldPassword = this.getNexusEmailer().getSMTPPassword();
        config.setPassword(this.getActualPassword(settings.getPassword(), oldPassword));
        config.setPort(settings.getPort());
        config.setSslEnabled(settings.isSslEnabled());
        config.setTlsEnabled(settings.isTlsEnabled());
        config.setUsername(settings.getUsername());
        config.setSystemEmailAddress(settings.getSystemEmailAddress().trim());
        try {
            status = this.emailer.sendSmtpConfigurationTest(config, email);
        }
        catch (EmailerException e) {
            throw new PlexusResourceException(Status.CLIENT_ERROR_BAD_REQUEST, (Throwable)e, (Object)this.getNexusErrorResponse("*", "Failed to send validation e-mail: " + this.parseReason(e)));
        }
        if (status) {
            response.setStatus(Status.SUCCESS_OK, "Email was sent. Check your inbox!");
        } else {
            response.setStatus(Status.SUCCESS_OK, "Unable to determine if e-mail was sent or not.  Check your inbox!");
        }
        return null;
    }

    private String parseReason(EmailerException e) {
        Throwable top = e;
        while (top.getCause() != null) {
            top = top.getCause();
        }
        if (top instanceof SSLPeerUnverifiedException) {
            return "Untrusted Remote";
        }
        if (top instanceof CertPathBuilderException) {
            return "Untrusted Remote (" + top.getMessage() + ")";
        }
        if (top instanceof UnknownHostException) {
            return "Unknown host '" + top.getMessage() + "'";
        }
        return top.getMessage();
    }

    static void validateEmail(String email) throws ResourceException {
        if (StringUtils.isEmpty((String)email)) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "E-mail address cannot be empty");
        }
        if (!EMAIL_PATTERN.matcher(email).matches()) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Invalid e-mail address: " + email);
        }
    }

    public void configureXStream(XStream xstream) {
        xstream.registerLocalConverter(SmtpSettingsResource.class, "username", (SingleValueConverter)new HtmlUnescapeStringConverter(true));
        xstream.registerLocalConverter(SmtpSettingsResource.class, "password", (SingleValueConverter)new HtmlUnescapeStringConverter(true));
    }
}

