/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.global;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.lang.StringUtils;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.micromailer.Address;
import org.sonatype.nexus.configuration.application.DefaultGlobalRemoteConnectionSettings;
import org.sonatype.nexus.configuration.application.DefaultGlobalRemoteProxySettings;
import org.sonatype.nexus.configuration.application.GlobalRemoteProxySettings;
import org.sonatype.nexus.configuration.model.CRemoteConnectionSettings;
import org.sonatype.nexus.configuration.model.CRemoteProxySettings;
import org.sonatype.nexus.configuration.model.CRestApiSettings;
import org.sonatype.nexus.configuration.model.CSmtpConfiguration;
import org.sonatype.nexus.configuration.model.Configuration;
import org.sonatype.nexus.configuration.source.ApplicationConfigurationSource;
import org.sonatype.nexus.notification.NotificationManager;
import org.sonatype.nexus.notification.NotificationTarget;
import org.sonatype.nexus.proxy.repository.RemoteProxySettings;
import org.sonatype.nexus.proxy.repository.UsernamePasswordRemoteAuthenticationSettings;
import org.sonatype.nexus.rest.global.AbstractGlobalConfigurationPlexusResource;
import org.sonatype.nexus.rest.model.GlobalConfigurationResource;
import org.sonatype.nexus.rest.model.GlobalConfigurationResourceResponse;
import org.sonatype.nexus.rest.model.HtmlUnescapeStringConverter;
import org.sonatype.nexus.rest.model.RemoteConnectionSettings;
import org.sonatype.nexus.rest.model.RemoteProxySettingsDTO;
import org.sonatype.nexus.rest.model.RestApiSettings;
import org.sonatype.nexus.rest.model.SmtpSettings;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;
import org.sonatype.plexus.rest.resource.PlexusResourceException;
import org.sonatype.security.configuration.model.SecurityConfiguration;
import org.sonatype.security.configuration.source.SecurityConfigurationSource;

@Named
@Singleton
@Path(value="/global_settings/{configName}")
@Produces(value={"application/xml", "application/json"})
@Consumes(value={"application/xml", "application/json"})
public class GlobalConfigurationPlexusResource
extends AbstractGlobalConfigurationPlexusResource {
    public static final String CONFIG_NAME_KEY = "configName";
    public static final String RESOURCE_URI = "/global_settings/{configName}";
    public static final String CURRENT_CONFIG_NAME = "current";
    public static final String DEFAULT_CONFIG_NAME = "default";
    private final NotificationManager notificationManager;
    private final SecurityConfigurationSource defaultSecurityConfigurationSource;
    private final ApplicationConfigurationSource configurationSource;

    @Inject
    public GlobalConfigurationPlexusResource(NotificationManager notificationManager, @Named(value="static") SecurityConfigurationSource defaultSecurityConfigurationSource, @Named(value="static") ApplicationConfigurationSource configurationSource) {
        this.notificationManager = notificationManager;
        this.defaultSecurityConfigurationSource = defaultSecurityConfigurationSource;
        this.configurationSource = configurationSource;
        this.setModifiable(true);
    }

    public boolean isDefaultAnonymousAccessEnabled() {
        return ((SecurityConfiguration)this.defaultSecurityConfigurationSource.getConfiguration()).isAnonymousAccessEnabled();
    }

    public String getDefaultAnonymousUsername() {
        return ((SecurityConfiguration)this.defaultSecurityConfigurationSource.getConfiguration()).getAnonymousUsername();
    }

    public String getDefaultAnonymousPassword() {
        return ((SecurityConfiguration)this.defaultSecurityConfigurationSource.getConfiguration()).getAnonymousPassword();
    }

    public List<String> getDefaultRealms() {
        return ((SecurityConfiguration)this.defaultSecurityConfigurationSource.getConfiguration()).getRealms();
    }

    public CRemoteConnectionSettings readDefaultGlobalRemoteConnectionSettings() {
        return ((Configuration)this.configurationSource.getConfiguration()).getGlobalConnectionSettings();
    }

    public CRemoteProxySettings readDefaultRemoteProxySettings() {
        return ((Configuration)this.configurationSource.getConfiguration()).getRemoteProxySettings();
    }

    public CRestApiSettings readDefaultRestApiSettings() {
        return ((Configuration)this.configurationSource.getConfiguration()).getRestApi();
    }

    public CSmtpConfiguration readDefaultSmtpConfiguration() {
        return ((Configuration)this.configurationSource.getConfiguration()).getSmtpConfiguration();
    }

    public Object getPayloadInstance() {
        return new GlobalConfigurationResourceResponse();
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/global_settings/*", "authcBasic,perms[nexus:settings]");
    }

    @GET
    @ResourceMethodSignature(pathParams={@PathParam(value="configName")}, output=GlobalConfigurationResourceResponse.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        String configurationName = request.getAttributes().get(CONFIG_NAME_KEY).toString();
        if (!DEFAULT_CONFIG_NAME.equals(configurationName) && !CURRENT_CONFIG_NAME.equals(configurationName)) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND);
        }
        GlobalConfigurationResource resource = new GlobalConfigurationResource();
        if (DEFAULT_CONFIG_NAME.equals(configurationName)) {
            this.fillDefaultConfiguration(request, resource);
        } else {
            this.fillCurrentConfiguration(request, resource);
        }
        GlobalConfigurationResourceResponse result = new GlobalConfigurationResourceResponse();
        result.setData(resource);
        return result;
    }

    @PUT
    @ResourceMethodSignature(pathParams={@PathParam(value="configName")}, input=GlobalConfigurationResourceResponse.class)
    public Object put(Context context, Request request, Response response, Object payload) throws ResourceException {
        String configurationName = request.getAttributes().get(CONFIG_NAME_KEY).toString();
        if (!DEFAULT_CONFIG_NAME.equals(configurationName) && !CURRENT_CONFIG_NAME.equals(configurationName)) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND);
        }
        if (!CURRENT_CONFIG_NAME.equals(configurationName)) {
            throw new ResourceException(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
        }
        GlobalConfigurationResourceResponse configRequest = (GlobalConfigurationResourceResponse)payload;
        if (configRequest != null) {
            GlobalConfigurationResource resource = configRequest.getData();
            try {
                if (resource.getSmtpSettings() != null) {
                    SmtpSettings settings = resource.getSmtpSettings();
                    this.getNexusEmailer().setSMTPHostname(settings.getHost());
                    String oldPassword = this.getNexusEmailer().getSMTPPassword();
                    if (settings.getPassword() == null) {
                        settings.setPassword("");
                    }
                    this.getNexusEmailer().setSMTPPassword(this.getActualPassword(settings.getPassword(), oldPassword));
                    this.getNexusEmailer().setSMTPPort(settings.getPort());
                    this.getNexusEmailer().setSMTPSslEnabled(settings.isSslEnabled());
                    this.getNexusEmailer().setSMTPTlsEnabled(settings.isTlsEnabled());
                    if (settings.getUsername() == null) {
                        settings.setUsername("");
                    }
                    this.getNexusEmailer().setSMTPUsername(settings.getUsername());
                    this.getNexusEmailer().setSMTPSystemEmailAddress(new Address(settings.getSystemEmailAddress().trim()));
                }
                if (resource.getGlobalConnectionSettings() != null) {
                    RemoteConnectionSettings s = resource.getGlobalConnectionSettings();
                    this.getGlobalRemoteConnectionSettings().setConnectionTimeout(s.getConnectionTimeout() * 1000);
                    this.getGlobalRemoteConnectionSettings().setRetrievalRetryCount(s.getRetrievalRetryCount());
                    this.getGlobalRemoteConnectionSettings().setQueryString(s.getQueryString());
                    this.getGlobalRemoteConnectionSettings().setUserAgentCustomizationString(s.getUserAgentString());
                }
                this.setGlobalProxySettings(resource.getRemoteProxySettings(), this.getGlobalRemoteProxySettings());
                this.getNexusConfiguration().setRealms(resource.getSecurityRealms());
                String anonymousUsername = resource.getSecurityAnonymousUsername();
                String anonymousPassword = this.getActualPassword(resource.getSecurityAnonymousPassword(), this.getNexusConfiguration().getAnonymousPassword());
                if (resource.isSecurityAnonymousAccessEnabled() && !StringUtils.isEmpty((String)anonymousUsername) && !StringUtils.isEmpty((String)anonymousPassword)) {
                    this.getNexusConfiguration().setAnonymousAccess(true, anonymousUsername, anonymousPassword);
                } else {
                    if (resource.isSecurityAnonymousAccessEnabled()) {
                        this.getLogger().warn("Nexus refused to apply configuration, the supplied anonymous username/pwd information is empty.");
                        throw new PlexusResourceException(Status.CLIENT_ERROR_BAD_REQUEST, (Object)this.getNexusErrorResponse("securityAnonymousUsername", "Cannot be empty when Anonynous access is enabled"));
                    }
                    this.getNexusConfiguration().setAnonymousAccess(false, null, null);
                }
                if (resource.getGlobalRestApiSettings() != null) {
                    RestApiSettings restApiSettings = resource.getGlobalRestApiSettings();
                    this.getGlobalRestApiSettings().setForceBaseUrl(restApiSettings.isForceBaseUrl());
                    if (StringUtils.isEmpty((String)resource.getGlobalRestApiSettings().getBaseUrl())) {
                        this.getGlobalRestApiSettings().setBaseUrl(null);
                    } else {
                        this.getGlobalRestApiSettings().setBaseUrl(new Reference(restApiSettings.getBaseUrl()).getTargetRef().toString());
                    }
                    this.getGlobalRestApiSettings().setUITimeout(restApiSettings.getUiTimeout() * 1000);
                } else {
                    this.getGlobalRestApiSettings().disable();
                }
                if (resource.getSystemNotificationSettings() != null) {
                    this.notificationManager.setEnabled(resource.getSystemNotificationSettings().isEnabled());
                    NotificationTarget target = this.notificationManager.readNotificationTarget("autoBlockTarget");
                    if (target == null) {
                        target = new NotificationTarget();
                        target.setTargetId("autoBlockTarget");
                    }
                    target.getTargetRoles().clear();
                    target.getTargetRoles().addAll(resource.getSystemNotificationSettings().getRoles());
                    target.getExternalTargets().clear();
                    if (StringUtils.isNotEmpty((String)resource.getSystemNotificationSettings().getEmailAddresses())) {
                        target.getExternalTargets().addAll(Arrays.asList(resource.getSystemNotificationSettings().getEmailAddresses().split(",")));
                    }
                    target.getTargetUsers().clear();
                    this.notificationManager.updateNotificationTarget(target);
                }
                boolean remoteConnectionSettingsIsDirty = ((DefaultGlobalRemoteConnectionSettings)this.getGlobalRemoteConnectionSettings()).isDirty();
                boolean remoteProxySettingsIsDirty = ((DefaultGlobalRemoteProxySettings)this.getGlobalRemoteProxySettings()).isDirty();
                this.getNexusConfiguration().saveConfiguration();
                if (remoteConnectionSettingsIsDirty) {
                    this.getNexusConfiguration().getGlobalRemoteStorageContext().setRemoteConnectionSettings((org.sonatype.nexus.proxy.repository.RemoteConnectionSettings)this.getGlobalRemoteConnectionSettings());
                }
                if (remoteProxySettingsIsDirty) {
                    this.getNexusConfiguration().getGlobalRemoteStorageContext().setRemoteProxySettings((RemoteProxySettings)this.getGlobalRemoteProxySettings());
                }
            }
            catch (IOException e) {
                this.getLogger().warn("Got IO Exception during update of Nexus configuration.", (Throwable)e);
                throw new ResourceException(Status.SERVER_ERROR_INTERNAL);
            }
            catch (InvalidConfigurationException e) {
                this.getLogger().debug("Configuraiton Exception while setting security values", (Throwable)e);
                this.handleInvalidConfigurationException(e);
            }
            catch (ConfigurationException e) {
                this.getLogger().warn("Nexus refused to apply configuration.", (Throwable)e);
                throw new PlexusResourceException(Status.CLIENT_ERROR_BAD_REQUEST, e.getMessage(), (Object)this.getNexusErrorResponse("*", e.getMessage()));
            }
        }
        response.setStatus(Status.SUCCESS_NO_CONTENT);
        return null;
    }

    private void setGlobalProxySettings(RemoteProxySettingsDTO remoteProxySettings, GlobalRemoteProxySettings remoteProxySettingsConfiguration) throws ConfigurationException {
        if (remoteProxySettings != null && remoteProxySettings.getHttpProxySettings() != null && !StringUtils.isEmpty((String)remoteProxySettings.getHttpProxySettings().getProxyHostname())) {
            String oldHttpProxyPassword = null;
            if (remoteProxySettingsConfiguration.getHttpProxySettings() != null && remoteProxySettingsConfiguration.getHttpProxySettings().getProxyAuthentication() != null) {
                oldHttpProxyPassword = ((UsernamePasswordRemoteAuthenticationSettings)remoteProxySettingsConfiguration.getHttpProxySettings().getProxyAuthentication()).getPassword();
            }
            String oldHttpsProxyPassword = null;
            if (remoteProxySettingsConfiguration.getHttpsProxySettings() != null && remoteProxySettingsConfiguration.getHttpsProxySettings().getProxyAuthentication() != null) {
                oldHttpsProxyPassword = ((UsernamePasswordRemoteAuthenticationSettings)remoteProxySettingsConfiguration.getHttpsProxySettings().getProxyAuthentication()).getPassword();
            }
            remoteProxySettingsConfiguration.setHttpProxySettings(this.convert(remoteProxySettings.getHttpProxySettings(), oldHttpProxyPassword));
            remoteProxySettingsConfiguration.setHttpsProxySettings(this.convert(remoteProxySettings.getHttpsProxySettings(), oldHttpsProxyPassword));
            List nonProxyHosts = remoteProxySettings.getNonProxyHosts();
            if (nonProxyHosts != null && !nonProxyHosts.isEmpty()) {
                HashSet<String> cleanNonProxyHosts = new HashSet<String>();
                for (String host : nonProxyHosts) {
                    if (!StringUtils.isNotEmpty((String)host)) continue;
                    cleanNonProxyHosts.add(host);
                }
                remoteProxySettingsConfiguration.setNonProxyHosts(cleanNonProxyHosts);
            } else {
                remoteProxySettingsConfiguration.setNonProxyHosts(null);
            }
        } else {
            remoteProxySettingsConfiguration.setHttpProxySettings(null);
            remoteProxySettingsConfiguration.setHttpsProxySettings(null);
            remoteProxySettingsConfiguration.setNonProxyHosts(null);
        }
    }

    protected void fillDefaultConfiguration(Request request, GlobalConfigurationResource resource) {
        resource.setSecurityAnonymousAccessEnabled(this.isDefaultAnonymousAccessEnabled());
        resource.setSecurityRealms(this.getDefaultRealms());
        resource.setSecurityAnonymousUsername(this.getDefaultAnonymousUsername());
        resource.setSecurityAnonymousPassword("|$|N|E|X|U|S|$|");
        resource.setGlobalConnectionSettings(GlobalConfigurationPlexusResource.convert(this.readDefaultGlobalRemoteConnectionSettings()));
        resource.setRemoteProxySettings(GlobalConfigurationPlexusResource.convert(this.readDefaultRemoteProxySettings()));
        RestApiSettings restApiSettings = GlobalConfigurationPlexusResource.convert(this.readDefaultRestApiSettings());
        if (restApiSettings != null) {
            restApiSettings.setBaseUrl(this.getContextRoot(request).getTargetRef().toString());
        }
        resource.setGlobalRestApiSettings(restApiSettings);
        resource.setSmtpSettings(GlobalConfigurationPlexusResource.convert(this.readDefaultSmtpConfiguration()));
    }

    protected void fillCurrentConfiguration(Request request, GlobalConfigurationResource resource) {
        resource.setSecurityAnonymousAccessEnabled(this.getNexusConfiguration().isAnonymousAccessEnabled());
        resource.setSecurityRealms(this.getNexusConfiguration().getRealms());
        resource.setSecurityAnonymousUsername(this.getNexusConfiguration().getAnonymousUsername());
        resource.setSecurityAnonymousPassword("|$|N|E|X|U|S|$|");
        resource.setGlobalConnectionSettings(GlobalConfigurationPlexusResource.convert(this.getGlobalRemoteConnectionSettings()));
        resource.setRemoteProxySettings(GlobalConfigurationPlexusResource.convert(this.getGlobalRemoteProxySettings()));
        RestApiSettings restApiSettings = GlobalConfigurationPlexusResource.convert(this.getGlobalRestApiSettings());
        if (restApiSettings != null && StringUtils.isEmpty((String)restApiSettings.getBaseUrl())) {
            restApiSettings.setBaseUrl(this.getContextRoot(request).getTargetRef().toString());
        }
        resource.setGlobalRestApiSettings(restApiSettings);
        resource.setSmtpSettings(GlobalConfigurationPlexusResource.convert(this.getNexusEmailer()));
        resource.setSystemNotificationSettings(GlobalConfigurationPlexusResource.convert(this.notificationManager));
    }

    protected String getSecurityConfiguration(boolean enabled, String authSourceType) {
        if (!enabled) {
            return "off";
        }
        if ("simple".equals(authSourceType)) {
            return "simple";
        }
        return "custom";
    }

    public void configureXStream(XStream xstream) {
        xstream.registerLocalConverter(SmtpSettings.class, "username", (SingleValueConverter)new HtmlUnescapeStringConverter(true));
        xstream.registerLocalConverter(SmtpSettings.class, "password", (SingleValueConverter)new HtmlUnescapeStringConverter(true));
    }
}

