/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.global;

import java.util.ArrayList;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.sonatype.configuration.ConfigurationException;
import org.sonatype.nexus.configuration.application.AuthenticationInfoConverter;
import org.sonatype.nexus.configuration.application.GlobalRemoteConnectionSettings;
import org.sonatype.nexus.configuration.application.GlobalRemoteProxySettings;
import org.sonatype.nexus.configuration.application.GlobalRestApiSettings;
import org.sonatype.nexus.configuration.model.CRemoteAuthentication;
import org.sonatype.nexus.configuration.model.CRemoteConnectionSettings;
import org.sonatype.nexus.configuration.model.CRemoteHttpProxySettings;
import org.sonatype.nexus.configuration.model.CRemoteProxySettings;
import org.sonatype.nexus.configuration.model.CRestApiSettings;
import org.sonatype.nexus.configuration.model.CSmtpConfiguration;
import org.sonatype.nexus.email.NexusEmailer;
import org.sonatype.nexus.notification.NotificationManager;
import org.sonatype.nexus.notification.NotificationTarget;
import org.sonatype.nexus.proxy.repository.ClientSSLRemoteAuthenticationSettings;
import org.sonatype.nexus.proxy.repository.DefaultRemoteHttpProxySettings;
import org.sonatype.nexus.proxy.repository.NtlmRemoteAuthenticationSettings;
import org.sonatype.nexus.proxy.repository.RemoteAuthenticationSettings;
import org.sonatype.nexus.proxy.repository.RemoteHttpProxySettings;
import org.sonatype.nexus.proxy.repository.UsernamePasswordRemoteAuthenticationSettings;
import org.sonatype.nexus.rest.AbstractNexusPlexusResource;
import org.sonatype.nexus.rest.model.AuthenticationSettings;
import org.sonatype.nexus.rest.model.RemoteConnectionSettings;
import org.sonatype.nexus.rest.model.RemoteHttpProxySettingsDTO;
import org.sonatype.nexus.rest.model.RemoteProxySettingsDTO;
import org.sonatype.nexus.rest.model.RestApiSettings;
import org.sonatype.nexus.rest.model.SmtpSettings;
import org.sonatype.nexus.rest.model.SystemNotificationSettings;

public abstract class AbstractGlobalConfigurationPlexusResource
extends AbstractNexusPlexusResource {
    public static final String SECURITY_OFF = "off";
    public static final String SECURITY_SIMPLE = "simple";
    public static final String SECURITY_CUSTOM = "custom";
    private NexusEmailer nexusEmailer;
    private GlobalRemoteProxySettings globalRemoteProxySettings;
    private GlobalRemoteConnectionSettings globalRemoteConnectionSettings;
    private GlobalRestApiSettings globalRestApiSettings;
    private AuthenticationInfoConverter authenticationInfoConverter;

    @Inject
    public void setNexusEmailer(NexusEmailer nexusEmailer) {
        this.nexusEmailer = nexusEmailer;
    }

    @Inject
    public void setGlobalRemoteProxySettings(GlobalRemoteProxySettings globalRemoteProxySettings) {
        this.globalRemoteProxySettings = globalRemoteProxySettings;
    }

    @Inject
    public void setGlobalRemoteConnectionSettings(GlobalRemoteConnectionSettings globalRemoteConnectionSettings) {
        this.globalRemoteConnectionSettings = globalRemoteConnectionSettings;
    }

    @Inject
    public void setGlobalRestApiSettings(GlobalRestApiSettings globalRestApiSettings) {
        this.globalRestApiSettings = globalRestApiSettings;
    }

    @Inject
    public void setAuthenticationInfoConverter(AuthenticationInfoConverter authenticationInfoConverter) {
        this.authenticationInfoConverter = authenticationInfoConverter;
    }

    protected NexusEmailer getNexusEmailer() {
        return this.nexusEmailer;
    }

    protected GlobalRemoteProxySettings getGlobalRemoteProxySettings() {
        return this.globalRemoteProxySettings;
    }

    protected GlobalRemoteConnectionSettings getGlobalRemoteConnectionSettings() {
        return this.globalRemoteConnectionSettings;
    }

    protected GlobalRestApiSettings getGlobalRestApiSettings() {
        return this.globalRestApiSettings;
    }

    protected AuthenticationInfoConverter getAuthenticationInfoConverter() {
        return this.authenticationInfoConverter;
    }

    public static SmtpSettings convert(NexusEmailer nexusEmailer) {
        if (nexusEmailer == null) {
            return null;
        }
        SmtpSettings result = new SmtpSettings();
        result.setHost(nexusEmailer.getSMTPHostname());
        result.setPort(nexusEmailer.getSMTPPort());
        result.setSslEnabled(nexusEmailer.isSMTPSslEnabled());
        result.setTlsEnabled(nexusEmailer.isSMTPTlsEnabled());
        result.setUsername(nexusEmailer.getSMTPUsername());
        if (!StringUtils.isEmpty((String)nexusEmailer.getSMTPPassword())) {
            result.setPassword("|$|N|E|X|U|S|$|");
        }
        result.setSystemEmailAddress(nexusEmailer.getSMTPSystemEmailAddress().getMailAddress());
        return result;
    }

    public static SystemNotificationSettings convert(NotificationManager manager) {
        if (manager == null) {
            return null;
        }
        SystemNotificationSettings settings = new SystemNotificationSettings();
        settings.setEnabled(manager.isEnabled());
        NotificationTarget target = manager.readNotificationTarget("autoBlockTarget");
        if (target == null) {
            return settings;
        }
        settings.getRoles().addAll(target.getTargetRoles());
        StringBuilder sb = new StringBuilder();
        for (String email : target.getExternalTargets()) {
            sb.append(email).append(",");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        settings.setEmailAddresses(sb.toString());
        return settings;
    }

    public static RemoteConnectionSettings convert(GlobalRemoteConnectionSettings settings) {
        if (settings == null) {
            return null;
        }
        RemoteConnectionSettings result = new RemoteConnectionSettings();
        result.setConnectionTimeout(settings.getConnectionTimeout() / 1000);
        result.setRetrievalRetryCount(settings.getRetrievalRetryCount());
        result.setQueryString(settings.getQueryString());
        result.setUserAgentString(settings.getUserAgentCustomizationString());
        return result;
    }

    public static RemoteProxySettingsDTO convert(GlobalRemoteProxySettings settings) {
        if (settings == null) {
            return null;
        }
        RemoteProxySettingsDTO result = new RemoteProxySettingsDTO();
        result.setHttpProxySettings(AbstractGlobalConfigurationPlexusResource.convert(settings.getHttpProxySettings()));
        result.setHttpsProxySettings(AbstractGlobalConfigurationPlexusResource.convert(settings.getHttpsProxySettings()));
        result.setNonProxyHosts(new ArrayList(settings.getNonProxyHosts()));
        return result;
    }

    public static RemoteHttpProxySettingsDTO convert(RemoteHttpProxySettings settings) {
        if (settings == null) {
            return null;
        }
        RemoteHttpProxySettingsDTO result = new RemoteHttpProxySettingsDTO();
        result.setProxyHostname(settings.getHostname());
        result.setProxyPort(settings.getPort());
        result.setAuthentication(AbstractGlobalConfigurationPlexusResource.convert(settings.getProxyAuthentication()));
        return result;
    }

    public static RestApiSettings convert(GlobalRestApiSettings settings) {
        if (settings == null || !settings.isEnabled()) {
            return null;
        }
        RestApiSettings result = new RestApiSettings();
        result.setBaseUrl(settings.getBaseUrl());
        result.setForceBaseUrl(settings.isForceBaseUrl());
        result.setUiTimeout(settings.getUITimeout() / 1000);
        return result;
    }

    public static AuthenticationSettings convert(RemoteAuthenticationSettings settings) {
        if (settings == null) {
            return null;
        }
        AuthenticationSettings auth = new AuthenticationSettings();
        if (!(settings instanceof ClientSSLRemoteAuthenticationSettings)) {
            if (settings instanceof NtlmRemoteAuthenticationSettings) {
                NtlmRemoteAuthenticationSettings up = (NtlmRemoteAuthenticationSettings)settings;
                auth.setUsername(up.getUsername());
                auth.setPassword("|$|N|E|X|U|S|$|");
                auth.setNtlmHost(up.getNtlmHost());
                auth.setNtlmDomain(up.getNtlmDomain());
            } else if (settings instanceof UsernamePasswordRemoteAuthenticationSettings) {
                UsernamePasswordRemoteAuthenticationSettings up = (UsernamePasswordRemoteAuthenticationSettings)settings;
                auth.setUsername(up.getUsername());
                auth.setPassword("|$|N|E|X|U|S|$|");
            }
        }
        return auth;
    }

    public static RemoteConnectionSettings convert(CRemoteConnectionSettings settings) {
        if (settings == null) {
            return null;
        }
        RemoteConnectionSettings result = new RemoteConnectionSettings();
        result.setConnectionTimeout(settings.getConnectionTimeout() / 1000);
        result.setRetrievalRetryCount(settings.getRetrievalRetryCount());
        result.setQueryString(settings.getQueryString());
        result.setUserAgentString(settings.getUserAgentCustomizationString());
        return result;
    }

    public static RemoteProxySettingsDTO convert(CRemoteProxySettings settings) {
        if (settings == null) {
            return null;
        }
        RemoteProxySettingsDTO result = new RemoteProxySettingsDTO();
        result.setHttpProxySettings(AbstractGlobalConfigurationPlexusResource.convert(settings.getHttpProxySettings()));
        result.setHttpsProxySettings(AbstractGlobalConfigurationPlexusResource.convert(settings.getHttpsProxySettings()));
        result.setNonProxyHosts(settings.getNonProxyHosts());
        return result;
    }

    public static RemoteHttpProxySettingsDTO convert(CRemoteHttpProxySettings settings) {
        if (settings == null) {
            return null;
        }
        RemoteHttpProxySettingsDTO result = new RemoteHttpProxySettingsDTO();
        result.setProxyHostname(settings.getProxyHostname());
        result.setProxyPort(settings.getProxyPort());
        result.setAuthentication(AbstractGlobalConfigurationPlexusResource.convert(settings.getAuthentication()));
        return result;
    }

    public static RestApiSettings convert(CRestApiSettings settings) {
        if (settings == null) {
            return null;
        }
        RestApiSettings result = new RestApiSettings();
        result.setBaseUrl(settings.getBaseUrl());
        result.setForceBaseUrl(settings.isForceBaseUrl());
        result.setUiTimeout(settings.getUiTimeout() / 1000);
        return result;
    }

    public static AuthenticationSettings convert(CRemoteAuthentication settings) {
        if (settings == null) {
            return null;
        }
        AuthenticationSettings auth = new AuthenticationSettings();
        auth.setUsername(settings.getUsername());
        auth.setPassword("|$|N|E|X|U|S|$|");
        auth.setNtlmHost(settings.getNtlmHost());
        auth.setNtlmDomain(settings.getNtlmDomain());
        return auth;
    }

    public static SmtpSettings convert(CSmtpConfiguration settings) {
        if (settings == null) {
            return null;
        }
        SmtpSettings result = new SmtpSettings();
        result.setHost(settings.getHostname());
        result.setPassword("|$|N|E|X|U|S|$|");
        result.setPort(settings.getPort());
        result.setSslEnabled(settings.isSslEnabled());
        result.setSystemEmailAddress(settings.getSystemEmailAddress());
        result.setTlsEnabled(settings.isTlsEnabled());
        result.setUsername(settings.getUsername());
        return result;
    }

    public RemoteHttpProxySettings convert(RemoteHttpProxySettingsDTO settings, String oldPassword) throws ConfigurationException {
        if (settings == null || StringUtils.isEmpty((String)settings.getProxyHostname())) {
            return null;
        }
        DefaultRemoteHttpProxySettings result = new DefaultRemoteHttpProxySettings();
        result.setHostname(settings.getProxyHostname());
        result.setPort(settings.getProxyPort());
        if (settings.getAuthentication() != null) {
            CRemoteAuthentication auth = new CRemoteAuthentication();
            auth.setUsername(settings.getAuthentication().getUsername());
            auth.setPassword(this.getActualPassword(settings.getAuthentication().getPassword(), oldPassword));
            auth.setNtlmDomain(settings.getAuthentication().getNtlmDomain());
            auth.setNtlmHost(settings.getAuthentication().getNtlmHost());
            result.setProxyAuthentication(this.getAuthenticationInfoConverter().convertAndValidateFromModel(auth));
        } else {
            result.setProxyAuthentication(null);
        }
        return result;
    }
}

