/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.contentclasses;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.nexus.proxy.registry.ContentClass;
import org.sonatype.nexus.proxy.registry.RepositoryTypeRegistry;
import org.sonatype.nexus.rest.AbstractNexusPlexusResource;
import org.sonatype.nexus.rest.model.RepositoryContentClassListResource;
import org.sonatype.nexus.rest.model.RepositoryContentClassListResourceResponse;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;

@Named
@Singleton
@Path(value="/components/repo_content_classes")
@Produces(value={"application/xml", "application/json"})
public class ContentClassComponentListPlexusResource
extends AbstractNexusPlexusResource {
    public static final String RESOURCE_URI = "/components/repo_content_classes";
    private final RepositoryTypeRegistry repoTypeRegistry;

    @Inject
    public ContentClassComponentListPlexusResource(RepositoryTypeRegistry repoTypeRegistry) {
        this.repoTypeRegistry = repoTypeRegistry;
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor(this.getResourceUri(), "authcBasic,perms[nexus:componentscontentclasses]");
    }

    public Object getPayloadInstance() {
        return null;
    }

    @GET
    @ResourceMethodSignature(output=RepositoryContentClassListResourceResponse.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        RepositoryContentClassListResourceResponse contentClasses = new RepositoryContentClassListResourceResponse();
        for (ContentClass contentClass : this.repoTypeRegistry.getContentClasses().values()) {
            RepositoryContentClassListResource resource = new RepositoryContentClassListResource();
            resource.setContentClass(contentClass.getId());
            resource.setName(contentClass.getName());
            resource.setGroupable(contentClass.isGroupable());
            for (String compClass : this.repoTypeRegistry.getCompatibleContentClasses(contentClass)) {
                resource.addCompatibleType(compClass);
            }
            contentClasses.addData(resource);
        }
        return contentClasses;
    }
}

