/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.configurations;

import java.io.IOException;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.nexus.NexusStreamResponse;
import org.sonatype.nexus.rest.AbstractNexusPlexusResource;
import org.sonatype.plexus.rest.representation.InputStreamRepresentation;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;

@Named
@Singleton
@Path(value="/configs/{configName}")
@Produces(value={"text/xml"})
public class ConfigurationPlexusResource
extends AbstractNexusPlexusResource {
    public static final String CONFIG_NAME_KEY = "configName";

    public Object getPayloadInstance() {
        return null;
    }

    public String getResourceUri() {
        return "/configs/{configName}";
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/configs/*", "authcBasic,perms[nexus:configuration]");
    }

    public List<Variant> getVariants() {
        List result = super.getVariants();
        result.clear();
        result.add(new Variant(MediaType.TEXT_PLAIN));
        result.add(new Variant(MediaType.APPLICATION_XML));
        return result;
    }

    @GET
    @ResourceMethodSignature(pathParams={@PathParam(value="configKey")}, output=String.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        String key = request.getAttributes().get(CONFIG_NAME_KEY).toString();
        try {
            if (!this.getNexusConfiguration().getConfigurationFiles().containsKey(key)) {
                throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, "No configuration with key '" + key + "' found!");
            }
            NexusStreamResponse result = this.getNexusConfiguration().getConfigurationAsStreamByKey(key);
            return new InputStreamRepresentation(MediaType.valueOf((String)result.getMimeType()), result.getInputStream());
        }
        catch (IOException e) {
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, "IOException during configuration retrieval!", (Throwable)e);
        }
    }
}

