/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.configurations;

import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.nexus.rest.AbstractNexusPlexusResource;
import org.sonatype.nexus.rest.model.ConfigurationsListResource;
import org.sonatype.nexus.rest.model.ConfigurationsListResourceResponse;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;

@Named
@Singleton
@Path(value="/configs")
@Produces(value={"application/xml", "application/json"})
public class ConfigurationListPlexusResource
extends AbstractNexusPlexusResource {
    public static final String RESOURCE_URI = "/configs";

    public Object getPayloadInstance() {
        return null;
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor(this.getResourceUri(), "authcBasic,perms[nexus:configuration]");
    }

    @GET
    @ResourceMethodSignature(output=ConfigurationsListResourceResponse.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        ConfigurationsListResourceResponse result = new ConfigurationsListResourceResponse();
        Map configFileNames = this.getNexusConfiguration().getConfigurationFiles();
        for (Map.Entry entry : configFileNames.entrySet()) {
            ConfigurationsListResource resource = new ConfigurationsListResource();
            resource.setResourceURI(this.createChildReference(request, this, (String)entry.getKey()).toString());
            resource.setName((String)entry.getValue());
            result.addData(resource);
        }
        return result;
    }
}

