/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.component;

import com.google.inject.Key;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.inject.BeanLocator;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.nexus.rest.AbstractNexusPlexusResource;
import org.sonatype.nexus.rest.model.PlexusComponentListResource;
import org.sonatype.nexus.rest.model.PlexusComponentListResourceResponse;

public abstract class AbstractComponentListPlexusResource
extends AbstractNexusPlexusResource {
    public static final String ROLE_ID = "role";
    private BeanLocator beanLocator;
    private ClassLoader uberClassLoader;

    @Inject
    public void setContainer(BeanLocator beanLocator, @Named(value="nexus-uber") ClassLoader uberClassLoader) {
        this.beanLocator = beanLocator;
        this.uberClassLoader = uberClassLoader;
    }

    public Object getPayloadInstance() {
        return null;
    }

    protected String getRole(Request request) {
        return request.getAttributes().get(ROLE_ID).toString();
    }

    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        PlexusComponentListResourceResponse result = new PlexusComponentListResourceResponse();
        String role = this.getRole(request);
        try {
            Key roleKey = Key.get(this.uberClassLoader.loadClass(role), Named.class);
            Iterable components = this.beanLocator.locate(roleKey);
            if (!components.iterator().hasNext()) {
                throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND);
            }
            for (BeanEntry entry : components) {
                PlexusComponentListResource resource = new PlexusComponentListResource();
                String hint = ((Named)entry.getKey()).value();
                String description = entry.getDescription();
                resource.setRoleHint(hint);
                resource.setDescription(StringUtils.isNotEmpty((String)description) ? description : hint);
                result.addData(resource);
            }
        }
        catch (ClassNotFoundException | LinkageError e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Unable to look up plexus component with role '" + role + "'.", e);
            }
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND);
        }
        return result;
    }
}

