/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.cache;

import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.cache.CacheStatistics;
import org.sonatype.nexus.proxy.repository.GroupRepository;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.rest.model.NFCRepositoryResource;
import org.sonatype.nexus.rest.model.NFCResource;
import org.sonatype.nexus.rest.model.NFCResourceResponse;
import org.sonatype.nexus.rest.model.NFCStats;
import org.sonatype.nexus.rest.restore.AbstractRestorePlexusResource;
import org.sonatype.nexus.scheduling.NexusTask;
import org.sonatype.nexus.tasks.ExpireCacheTask;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;

@Named
@Singleton
@Path(value="/data_cache/{domain}/{target}/content")
@Produces(value={"application/xml", "application/json"})
public class CachePlexusResource
extends AbstractRestorePlexusResource {
    public static final String RESOURCE_URI = "/data_cache/{domain}/{target}/content";

    public CachePlexusResource() {
        this.setRequireStrictChecking(false);
    }

    public Object getPayloadInstance() {
        return null;
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor("/data_cache/*/*/content/**", "authcBasic,perms[nexus:cache]");
    }

    @GET
    @ResourceMethodSignature(pathParams={@PathParam(value="domain"), @PathParam(value="target")}, output=NFCResourceResponse.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        try {
            NFCResource resource = new NFCResource();
            if (this.getRepositoryGroupId(request) != null) {
                for (Repository repository : ((GroupRepository)this.getRepositoryRegistry().getRepositoryWithFacet(this.getRepositoryGroupId(request), GroupRepository.class)).getMemberRepositories()) {
                    NFCRepositoryResource repoNfc = this.createNFCRepositoryResource(repository);
                    resource.addNfcContent(repoNfc);
                }
            } else if (this.getRepositoryId(request) != null) {
                Repository repository = this.getRepositoryRegistry().getRepository(this.getRepositoryId(request));
                NFCRepositoryResource repoNfc = this.createNFCRepositoryResource(repository);
                resource.addNfcContent(repoNfc);
            }
            NFCResourceResponse result = new NFCResourceResponse();
            result.setData(resource);
            return result;
        }
        catch (NoSuchRepositoryException e) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, e.getMessage());
        }
    }

    protected NFCRepositoryResource createNFCRepositoryResource(Repository repository) {
        NFCRepositoryResource repoNfc = new NFCRepositoryResource();
        repoNfc.setRepositoryId(repository.getId());
        CacheStatistics stats = repository.getNotFoundCache().getStatistics();
        NFCStats restStats = new NFCStats();
        restStats.setSize(stats.getSize());
        restStats.setHits(stats.getHits());
        restStats.setMisses(stats.getMisses());
        repoNfc.setNfcStats(restStats);
        repoNfc.getNfcPaths().addAll(repository.getNotFoundCache().listKeysInCache());
        return repoNfc;
    }

    @DELETE
    @ResourceMethodSignature(pathParams={@PathParam(value="domain"), @PathParam(value="target")})
    public void delete(Context context, Request request, Response response) throws ResourceException {
        ExpireCacheTask task = (ExpireCacheTask)this.getNexusScheduler().createTaskInstance(ExpireCacheTask.class);
        String repositoryId = this.getRepositoryId(request);
        if (repositoryId == null) {
            repositoryId = this.getRepositoryGroupId(request);
        }
        task.setRepositoryId(repositoryId);
        task.setResourceStorePath(this.getResourceStorePath(request));
        this.handleDelete((NexusTask<?>)task, request);
    }
}

