/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.artifact;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Random;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.sonatype.nexus.rest.model.ArtifactCoordinate;

public class PomArtifactManager {
    private File tmpStorage = null;
    private File tmpPomFile = null;
    private int state = 0;
    private ArtifactCoordinate artifactCoordinate;
    private static final int STATE_NONE = 0;
    private static final int STATE_FILE_STORED = 1;
    private static final int STATE_GAV_PARSED = 2;
    private static final Random identifierGenerator = new Random();

    public PomArtifactManager(File tmpStorage) {
        this.tmpStorage = tmpStorage;
    }

    public void storeTempPomFile(InputStream is) throws IOException {
        if (0 != this.state) {
            throw new IllegalStateException("There is already a temporary pom file managed by this PomArtifactManager");
        }
        this.tmpPomFile = new File(this.tmpStorage, this.getNextIdentifier() + ".xml");
        this.tmpPomFile.deleteOnExit();
        try (InputStream in = is;
             FileOutputStream out = new FileOutputStream(this.tmpPomFile);){
            IOUtils.copy((InputStream)is, (OutputStream)out);
            this.state = 1;
        }
    }

    public InputStream getTempPomFileInputStream() throws IOException {
        if (1 > this.state) {
            throw new IllegalStateException("The temporary pom file has not yet been stored");
        }
        return new FileInputStream(this.tmpPomFile);
    }

    public ArtifactCoordinate getArtifactCoordinateFromTempPomFile() throws IOException, XmlPullParserException {
        if (1 > this.state) {
            throw new IllegalStateException("The temporary POM file has not yet been stored");
        }
        if (2 == this.state) {
            return this.artifactCoordinate;
        }
        try (XmlStreamReader reader = ReaderFactory.newXmlReader((File)this.tmpPomFile);){
            this.artifactCoordinate = this.parsePom((Reader)reader);
            this.state = 2;
        }
        return this.artifactCoordinate;
    }

    public void removeTempPomFile() {
        if (1 > this.state) {
            throw new IllegalStateException("The temporary pom file has not yet been stored");
        }
        this.tmpPomFile.delete();
        this.artifactCoordinate = null;
        this.state = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextIdentifier() {
        Random random = identifierGenerator;
        synchronized (random) {
            return identifierGenerator.nextLong();
        }
    }

    private ArtifactCoordinate parsePom(Reader reader) throws IOException, XmlPullParserException {
        String groupId = null;
        String artifactId = null;
        String version = null;
        String packaging = "jar";
        MXParser parser = new MXParser();
        parser.setInput(reader);
        boolean foundRoot = false;
        boolean inParent = false;
        int eventType = parser.getEventType();
        while (eventType != 1) {
            if (eventType == 2) {
                if (parser.getName().equals("project")) {
                    foundRoot = true;
                } else if (parser.getName().equals("parent")) {
                    inParent = true;
                } else if (parser.getName().equals("groupId")) {
                    if (parser.getDepth() == 2 || inParent && groupId == null) {
                        groupId = StringUtils.trim((String)parser.nextText());
                    }
                } else if (parser.getName().equals("artifactId")) {
                    if (parser.getDepth() == 2 || inParent && artifactId == null) {
                        artifactId = StringUtils.trim((String)parser.nextText());
                    }
                } else if (parser.getName().equals("version")) {
                    if (parser.getDepth() == 2 || inParent && version == null) {
                        version = StringUtils.trim((String)parser.nextText());
                    }
                } else if (parser.getName().equals("packaging")) {
                    if (parser.getDepth() == 2) {
                        packaging = StringUtils.trim((String)parser.nextText());
                    }
                } else if (!foundRoot) {
                    throw new XmlPullParserException("Unrecognised tag: '" + parser.getName() + "'", (XmlPullParser)parser, null);
                }
            } else if (eventType == 3 && parser.getName().equals("parent")) {
                inParent = false;
            }
            eventType = parser.next();
        }
        ArtifactCoordinate artifactCoordinates = new ArtifactCoordinate();
        artifactCoordinates.setGroupId(groupId);
        artifactCoordinates.setArtifactId(artifactId);
        artifactCoordinates.setVersion(version);
        artifactCoordinates.setPackaging(packaging);
        return artifactCoordinates;
    }
}

