/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.artifact;

import java.io.IOException;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.restlet.data.Request;
import org.sonatype.nexus.proxy.ResourceStoreRequest;
import org.sonatype.nexus.proxy.item.RepositoryItemUid;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.maven.gav.Gav;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.rest.AbstractArtifactViewProvider;
import org.sonatype.nexus.rest.model.Maven2ArtifactInfoResource;
import org.sonatype.nexus.rest.model.Maven2ArtifactInfoResourceRespose;

@Named(value="maven2")
@Singleton
public class Maven2ArtifactViewProvider
extends AbstractArtifactViewProvider {
    @Override
    public Object retrieveView(ResourceStoreRequest request, RepositoryItemUid itemUid, StorageItem item, Request req) throws IOException {
        Repository itemRepository = itemUid.getRepository();
        String itemPath = itemUid.getPath();
        if (!itemRepository.getRepositoryKind().isFacetAvailable(MavenRepository.class)) {
            return null;
        }
        MavenRepository mavenRepository = (MavenRepository)itemRepository.adaptToFacet(MavenRepository.class);
        Gav gav = mavenRepository.getGavCalculator().pathToGav(itemPath);
        if (gav == null || gav.isSignature() || gav.isHash()) {
            return null;
        }
        Maven2ArtifactInfoResourceRespose response = new Maven2ArtifactInfoResourceRespose();
        Maven2ArtifactInfoResource data = new Maven2ArtifactInfoResource();
        response.setData(data);
        data.setGroupId(gav.getGroupId());
        data.setArtifactId(gav.getArtifactId());
        data.setBaseVersion(gav.getBaseVersion());
        data.setVersion(gav.getVersion());
        data.setExtension(gav.getExtension());
        data.setClassifier(gav.getClassifier());
        data.setDependencyXmlChunk(this.generateDependencyXml(gav));
        return response;
    }

    private String generateDependencyXml(Gav gav) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<dependency>\n");
        buffer.append("  <groupId>").append(gav.getGroupId()).append("</groupId>\n");
        buffer.append("  <artifactId>").append(gav.getArtifactId()).append("</artifactId>\n");
        buffer.append("  <version>").append(gav.getBaseVersion()).append("</version>\n");
        if (StringUtils.isNotEmpty((String)gav.getClassifier())) {
            buffer.append("  <classifier>").append(gav.getClassifier()).append("</classifier>\n");
        }
        if (StringUtils.isNotEmpty((String)gav.getExtension()) && !StringUtils.equalsIgnoreCase((String)"jar", (String)gav.getExtension())) {
            buffer.append("  <type>").append(gav.getExtension()).append("</type>\n");
        }
        buffer.append("</dependency>");
        return buffer.toString();
    }
}

