/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.artifact;

import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang.StringUtils;
import org.codehaus.enunciate.contract.jaxrs.ResourceMethodSignature;
import org.restlet.Context;
import org.restlet.data.Form;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.nexus.proxy.attributes.inspectors.DigestCalculatingInspector;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.maven.ArtifactStoreHelper;
import org.sonatype.nexus.proxy.maven.ArtifactStoreRequest;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.maven.gav.Gav;
import org.sonatype.nexus.rest.artifact.AbstractArtifactPlexusResource;
import org.sonatype.nexus.rest.model.ArtifactResolveResource;
import org.sonatype.nexus.rest.model.ArtifactResolveResourceResponse;
import org.sonatype.plexus.rest.resource.PathProtectionDescriptor;

@Named
@Singleton
@Path(value="/artifact/maven/resolve")
@Produces(value={"application/xml", "application/json"})
public class ArtifactResolvePlexusResource
extends AbstractArtifactPlexusResource {
    public static final String RESOURCE_URI = "/artifact/maven/resolve";

    public Object getPayloadInstance() {
        return null;
    }

    public String getResourceUri() {
        return RESOURCE_URI;
    }

    public PathProtectionDescriptor getResourceProtection() {
        return new PathProtectionDescriptor(this.getResourceUri(), "authcBasic,perms[nexus:artifact]");
    }

    @GET
    @ResourceMethodSignature(queryParams={@QueryParam(value="g"), @QueryParam(value="a"), @QueryParam(value="v"), @QueryParam(value="r"), @QueryParam(value="p"), @QueryParam(value="c"), @QueryParam(value="e")}, output=ArtifactResolveResourceResponse.class)
    public Object get(Context context, Request request, Response response, Variant variant) throws ResourceException {
        Form form = request.getResourceRef().getQueryAsForm();
        String groupId = form.getFirstValue("g");
        String artifactId = form.getFirstValue("a");
        String version = form.getFirstValue("v");
        String packaging = form.getFirstValue("p");
        String classifier = form.getFirstValue("c");
        String repositoryId = form.getFirstValue("r");
        String extension = form.getFirstValue("e");
        if (groupId == null || artifactId == null || version == null || repositoryId == null) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "At least following request parameters have to be given: gavr!");
        }
        if (StringUtils.isBlank((String)packaging)) {
            packaging = "jar";
        }
        boolean isLocalOnly = this.isLocal(request, null);
        ArtifactStoreRequest gavRequest = this.getResourceStoreRequest(request, false, false, repositoryId, groupId, artifactId, version, packaging, classifier, extension);
        try {
            MavenRepository mavenRepository = this.getMavenRepository(repositoryId);
            ArtifactStoreHelper helper = mavenRepository.getArtifactStoreHelper();
            Gav resolvedGav = helper.resolveArtifact(gavRequest);
            String repositoryPath = mavenRepository.getGavCalculator().gavToPath(resolvedGav);
            StorageFileItem resolvedFile = null;
            if (!isLocalOnly) {
                resolvedFile = helper.retrieveArtifact(gavRequest);
            }
            ArtifactResolveResource resource = new ArtifactResolveResource();
            resource.setPresentLocally(resolvedFile != null);
            if (resolvedFile != null) {
                resource.setSha1(resolvedFile.getRepositoryItemAttributes().get(DigestCalculatingInspector.DIGEST_SHA1_KEY));
            }
            resource.setGroupId(resolvedGav.getGroupId());
            resource.setArtifactId(resolvedGav.getArtifactId());
            resource.setVersion(resolvedGav.getVersion());
            resource.setClassifier(resolvedGav.getClassifier());
            resource.setExtension(resolvedGav.getExtension());
            resource.setFileName(resolvedGav.getName());
            resource.setRepositoryPath(repositoryPath);
            resource.setSnapshot(resolvedGav.isSnapshot());
            if (resource.isSnapshot()) {
                resource.setBaseVersion(resolvedGav.getBaseVersion());
                if (resolvedGav.getSnapshotBuildNumber() != null) {
                    resource.setSnapshotBuildNumber((long)resolvedGav.getSnapshotBuildNumber().intValue());
                    resource.setSnapshotTimeStamp(resolvedGav.getSnapshotTimeStamp().longValue());
                }
            }
            ArtifactResolveResourceResponse result = new ArtifactResolveResourceResponse();
            result.setData(resource);
            return result;
        }
        catch (Exception e) {
            this.handleException(request, response, e);
            return null;
        }
    }
}

