/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest.artifact;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Model;
import org.apache.shiro.subject.Subject;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.restlet.Context;
import org.restlet.data.Form;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import org.restlet.resource.Variant;
import org.sonatype.nexus.proxy.AccessDeniedException;
import org.sonatype.nexus.proxy.IllegalOperationException;
import org.sonatype.nexus.proxy.IllegalRequestException;
import org.sonatype.nexus.proxy.ItemNotFoundException;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.NoSuchResourceStoreException;
import org.sonatype.nexus.proxy.RemoteStorageTransportOverloadedException;
import org.sonatype.nexus.proxy.RepositoryNotAvailableException;
import org.sonatype.nexus.proxy.StorageException;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.maven.ArtifactStoreHelper;
import org.sonatype.nexus.proxy.maven.ArtifactStoreRequest;
import org.sonatype.nexus.proxy.maven.MavenRepository;
import org.sonatype.nexus.proxy.maven.RepositoryPolicy;
import org.sonatype.nexus.proxy.maven.gav.Gav;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.storage.UnsupportedStorageOperationException;
import org.sonatype.nexus.rest.AbstractNexusPlexusResource;
import org.sonatype.nexus.rest.AbstractResourceStoreContentPlexusResource;
import org.sonatype.nexus.rest.StorageFileItemRepresentation;
import org.sonatype.nexus.rest.artifact.PomArtifactManager;
import org.sonatype.nexus.rest.model.ArtifactCoordinate;
import org.sonatype.security.SecuritySystem;

public abstract class AbstractArtifactPlexusResource
extends AbstractNexusPlexusResource {
    private SecuritySystem securitySystem;
    private Pattern validInputPattern = Pattern.compile("^[a-zA-Z0-9_\\-\\.]*$");

    @Inject
    public void setSecuritySystem(SecuritySystem securitySystem) {
        this.securitySystem = securitySystem;
    }

    protected ArtifactStoreRequest getResourceStoreRequest(Request request, boolean localOnly, boolean remoteOnly, String repositoryId, String g, String a, String v, String p, String c, String e) throws ResourceException {
        if (StringUtils.isBlank((String)p) && StringUtils.isBlank((String)e)) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Deployment tried with both 'packaging' and/or 'extension' being empty! One of these values is mandatory!");
        }
        MavenRepository mavenRepository = this.getMavenRepository(repositoryId);
        if (StringUtils.isBlank((String)e)) {
            e = mavenRepository.getArtifactPackagingMapper().getExtensionForPackaging(p);
        }
        if (StringUtils.isBlank((String)c)) {
            c = null;
        }
        Gav gav = new Gav(g, a, v, c, e, null, null, null, false, null, false, null);
        ArtifactStoreRequest result = new ArtifactStoreRequest(mavenRepository, gav, localOnly, remoteOnly);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Created ArtifactStoreRequest request for " + result.getRequestPath());
        }
        result.getRequestContext().put("request.address", (Object)this.getValidRemoteIPAddress(request));
        Subject subject = this.securitySystem.getSubject();
        if (subject != null && subject.getPrincipal() != null) {
            result.getRequestContext().put("request.user", (Object)subject.getPrincipal().toString());
        }
        result.getRequestContext().put("request.agent", (Object)request.getClientInfo().getAgent());
        if (request.isConfidential()) {
            result.getRequestContext().put("request.isConfidential", (Object)Boolean.TRUE);
            List certs = (List)request.getAttributes().get("org.restlet.https.clientCertificates");
            if (certs != null) {
                result.getRequestContext().put("request.certificates", (Object)certs);
            }
        }
        result.setRequestUrl(request.getOriginalRef().toString());
        return result;
    }

    /*
     * Exception decompiling
     */
    protected Model getPom(Variant variant, Request request, Response response) throws ResourceException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Object getContent(Variant variant, boolean redirectTo, Request request, Response response) throws ResourceException {
        Form form = request.getResourceRef().getQueryAsForm();
        String groupId = form.getFirstValue("g");
        String artifactId = form.getFirstValue("a");
        String version = form.getFirstValue("v");
        String packaging = form.getFirstValue("p");
        String classifier = form.getFirstValue("c");
        String repositoryId = form.getFirstValue("r");
        String extension = form.getFirstValue("e");
        if (groupId == null || artifactId == null || version == null || repositoryId == null) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST);
        }
        if (StringUtils.isBlank((String)packaging)) {
            packaging = "jar";
        }
        ArtifactStoreRequest gavRequest = this.getResourceStoreRequest(request, false, false, repositoryId, groupId, artifactId, version, packaging, classifier, extension);
        gavRequest.setRequestLocalOnly(this.isLocal(request, gavRequest.getRequestPath()));
        try {
            MavenRepository mavenRepository = this.getMavenRepository(repositoryId);
            ArtifactStoreHelper helper = mavenRepository.getArtifactStoreHelper();
            StorageFileItem file = helper.retrieveArtifact(gavRequest);
            if (redirectTo) {
                Reference fileReference = this.createRepositoryReference(request, file.getRepositoryItemUid().getRepository().getId(), file.getRepositoryItemUid().getPath());
                response.setLocationRef(fileReference);
                response.setStatus(Status.REDIRECTION_TEMPORARY);
                String redirectMessage = "If you are not automatically redirected use this url: " + fileReference.toString();
                return redirectMessage;
            }
            StorageFileItemRepresentation result = new StorageFileItemRepresentation(file);
            result.setDownloadable(true);
            result.setDownloadName(file.getName());
            return result;
        }
        catch (Exception e) {
            this.handleException(request, response, e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object upload(Context context, Request request, Response response, List<FileItem> files) throws ResourceException {
        PomArtifactManager pomManager = new PomArtifactManager(this.getNexusConfiguration().getTemporaryDirectory());
        UploadContext uploadContext = this.createUploadContext();
        try {
            for (FileItem fi : files) {
                if (fi.isFormField()) {
                    this.processFormField(request, uploadContext, fi);
                    continue;
                }
                boolean isPom = fi.getName().endsWith(".pom") || fi.getName().endsWith("pom.xml");
                InputStream is = null;
                ArtifactStoreRequest gavRequest = null;
                if (uploadContext.isPomAvailable()) {
                    if (isPom) {
                        pomManager.storeTempPomFile(fi.getInputStream());
                        is = pomManager.getTempPomFileInputStream();
                    } else {
                        is = fi.getInputStream();
                    }
                    try {
                        ArtifactCoordinate coords = pomManager.getArtifactCoordinateFromTempPomFile();
                        uploadContext.setGroupId(coords.getGroupId());
                        uploadContext.setArtifactId(coords.getArtifactId());
                        uploadContext.setVersion(coords.getVersion());
                        uploadContext.setPackaging(coords.getPackaging());
                    }
                    catch (IOException e) {
                        this.getLogger().info("Error occurred while reading the POM file. Malformed POM?", (Throwable)e);
                        throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Error occurred while reading the POM file. Malformed POM?", (Throwable)e);
                    }
                    if (isPom) {
                        this.uploadGavParametersAvailable(request, uploadContext);
                        gavRequest = this.getResourceStoreRequest(request, true, false, uploadContext.getRepositoryId(), uploadContext.getGroupId(), uploadContext.getArtifactId(), uploadContext.getVersion(), uploadContext.getPackaging(), null, null);
                    } else {
                        gavRequest = this.getResourceStoreRequest(request, true, false, uploadContext.getRepositoryId(), uploadContext.getGroupId(), uploadContext.getArtifactId(), uploadContext.getVersion(), uploadContext.getPackaging(), uploadContext.getClassifier(), uploadContext.getExtension());
                    }
                } else {
                    this.uploadGavParametersAvailable(request, uploadContext);
                    is = fi.getInputStream();
                    gavRequest = this.getResourceStoreRequest(request, true, false, uploadContext.getRepositoryId(), uploadContext.getGroupId(), uploadContext.getArtifactId(), uploadContext.getVersion(), uploadContext.getPackaging(), uploadContext.getClassifier(), uploadContext.getExtension());
                }
                MavenRepository mr = gavRequest.getMavenRepository();
                ArtifactStoreHelper helper = mr.getArtifactStoreHelper();
                if (RepositoryPolicy.SNAPSHOT.equals((Object)mr.getRepositoryPolicy())) {
                    this.getLogger().info("Upload to SNAPSHOT maven repository {} attempted, returning Bad Request.", (Object)mr);
                    throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "This is a Maven SNAPSHOT repository, and manual upload against it is forbidden!");
                }
                if (!this.versionMatchesPolicy(gavRequest.getVersion(), mr.getRepositoryPolicy())) {
                    this.getLogger().info("Artifact version {} and {} Repository Policy {} mismatch", new Object[]{gavRequest.getVersion(), mr, mr.getRepositoryPolicy()});
                    throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "The version " + gavRequest.getVersion() + " does not match the repository policy!");
                }
                if (isPom) {
                    helper.storeArtifactPom(gavRequest, is, null);
                    isPom = false;
                    continue;
                }
                if (uploadContext.isPomAvailable()) {
                    helper.storeArtifact(gavRequest, is, null);
                    continue;
                }
                helper.storeArtifactWithGeneratedPom(gavRequest, uploadContext.getPackaging(), is, null);
            }
        }
        catch (Exception t) {
            String string = this.buildUploadFailedHtmlResponse(t, request, response);
            return string;
        }
        finally {
            if (uploadContext.isPomAvailable()) {
                pomManager.removeTempPomFile();
            }
        }
        ArtifactCoordinate coords = new ArtifactCoordinate();
        coords.setGroupId(uploadContext.getGroupId());
        coords.setArtifactId(uploadContext.getArtifactId());
        coords.setVersion(uploadContext.getVersion());
        coords.setPackaging(uploadContext.getPackaging());
        return coords;
    }

    protected UploadContext createUploadContext() {
        return new UploadContext();
    }

    protected void processFormField(Request request, UploadContext uploadContext, FileItem fi) throws ResourceException {
        if (!this.validInputPattern.matcher(fi.getString()).matches()) {
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "Only letters, digits, underscores(_), hyphens(-), and dots(.) are allowed");
        }
        if ("r".equals(fi.getFieldName())) {
            uploadContext.setRepositoryId(fi.getString());
        } else if ("g".equals(fi.getFieldName())) {
            uploadContext.setGroupId(fi.getString());
        } else if ("a".equals(fi.getFieldName())) {
            uploadContext.setArtifactId(fi.getString());
        } else if ("v".equals(fi.getFieldName())) {
            uploadContext.setVersion(fi.getString());
        } else if ("p".equals(fi.getFieldName())) {
            uploadContext.setPackaging(fi.getString());
        } else if ("c".equals(fi.getFieldName())) {
            uploadContext.setClassifier(fi.getString());
        } else if ("e".equals(fi.getFieldName())) {
            uploadContext.setExtension(fi.getString());
        } else if ("hasPom".equals(fi.getFieldName())) {
            uploadContext.setPomAvailable(Boolean.parseBoolean(fi.getString()));
        }
    }

    protected void uploadGavParametersAvailable(Request request, UploadContext uploadContext) throws ResourceException {
    }

    protected String buildUploadFailedHtmlResponse(Throwable t, Request request, Response response) {
        try {
            this.handleException(request, response, t);
        }
        catch (ResourceException e) {
            this.getLogger().debug("Got error while uploading artifact", t);
            StringBuilder resp = new StringBuilder();
            resp.append("<html><body><error>");
            resp.append(StringEscapeUtils.escapeHtml((String)e.getMessage()));
            resp.append("</error></body></html>");
            String forceSuccess = request.getResourceRef().getQueryAsForm().getFirstValue("forceSuccess");
            if (!"true".equals(forceSuccess)) {
                response.setStatus(e.getStatus());
            }
            return resp.toString();
        }
        return null;
    }

    protected void handleException(Request request, Response res, Throwable t) throws ResourceException {
        if (t instanceof ResourceException) {
            throw (ResourceException)t;
        }
        if (t instanceof IllegalArgumentException) {
            this.getLogger().info("ResourceStoreContentResource, illegal argument:" + t.getMessage());
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, t.getMessage());
        }
        if (t instanceof RemoteStorageTransportOverloadedException) {
            throw new ResourceException(Status.SERVER_ERROR_SERVICE_UNAVAILABLE, t);
        }
        if (t instanceof RepositoryNotAvailableException) {
            throw new ResourceException(Status.SERVER_ERROR_SERVICE_UNAVAILABLE, t.getMessage());
        }
        if (t instanceof IllegalRequestException) {
            this.getLogger().info("ResourceStoreContentResource, illegal request:" + t.getMessage());
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, t.getMessage());
        }
        if (t instanceof IllegalOperationException) {
            this.getLogger().info("ResourceStoreContentResource, illegal operation:" + t.getMessage());
            throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, t.getMessage());
        }
        if (t instanceof StorageException) {
            this.getLogger().warn("IO problem!", t);
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, t.getMessage());
        }
        if (t instanceof UnsupportedStorageOperationException) {
            throw new ResourceException(Status.CLIENT_ERROR_FORBIDDEN, t.getMessage());
        }
        if (t instanceof NoSuchResourceStoreException) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, t.getMessage());
        }
        if (t instanceof ItemNotFoundException) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, t.getMessage());
        }
        if (t instanceof AccessDeniedException) {
            AbstractResourceStoreContentPlexusResource.challengeIfNeeded(request, res, (AccessDeniedException)t);
            if (Status.CLIENT_ERROR_FORBIDDEN.equals((Object)res.getStatus())) {
                throw new ResourceException(Status.CLIENT_ERROR_FORBIDDEN, t.getMessage());
            }
        } else {
            if (t instanceof XmlPullParserException) {
                throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, t.getMessage());
            }
            if (t instanceof IOException) {
                this.getLogger().warn("IO error!", t);
                throw new ResourceException(Status.SERVER_ERROR_INTERNAL, t.getMessage());
            }
            this.getLogger().warn(t.getMessage(), t);
            throw new ResourceException(Status.SERVER_ERROR_INTERNAL, t.getMessage());
        }
    }

    protected MavenRepository getMavenRepository(String id) throws ResourceException {
        try {
            Repository repository = this.getUnprotectedRepositoryRegistry().getRepository(id);
            if (!repository.getRepositoryKind().isFacetAvailable(MavenRepository.class)) {
                throw new ResourceException(Status.CLIENT_ERROR_BAD_REQUEST, "This is not a Maven repository!");
            }
            return (MavenRepository)repository.adaptToFacet(MavenRepository.class);
        }
        catch (NoSuchRepositoryException e) {
            throw new ResourceException(Status.CLIENT_ERROR_NOT_FOUND, e.getMessage(), (Throwable)e);
        }
    }

    protected boolean versionMatchesPolicy(String version, RepositoryPolicy policy) {
        boolean result = false;
        if (RepositoryPolicy.SNAPSHOT.equals((Object)policy) && Gav.isSnapshot((String)version) || RepositoryPolicy.RELEASE.equals((Object)policy) && !Gav.isSnapshot((String)version)) {
            result = true;
        }
        return result;
    }

    protected static class UploadContext {
        private String repositoryId = null;
        private boolean pomAvailable = false;
        private String extension = null;
        private String classifier = null;
        private String groupId = null;
        private String artifactId = null;
        private String version = null;
        private String packaging = null;

        protected UploadContext() {
        }

        public String getRepositoryId() {
            return this.repositoryId;
        }

        public void setRepositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
        }

        public boolean isPomAvailable() {
            return this.pomAvailable;
        }

        public void setPomAvailable(boolean pomAvailable) {
            this.pomAvailable = pomAvailable;
        }

        public String getExtension() {
            return this.extension;
        }

        public void setExtension(String extension) {
            this.extension = extension;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public void setClassifier(String classifier) {
            this.classifier = classifier;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getPackaging() {
            return this.packaging;
        }

        public void setPackaging(String packaging) {
            this.packaging = packaging;
        }
    }
}

