/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import org.restlet.data.MediaType;
import org.restlet.data.Tag;
import org.sonatype.nexus.proxy.attributes.inspectors.DigestCalculatingInspector;
import org.sonatype.nexus.proxy.item.StorageFileItem;
import org.sonatype.nexus.proxy.item.StorageItem;
import org.sonatype.nexus.rest.StorageItemRepresentation;
import org.sonatype.nexus.util.SystemPropertiesHelper;
import org.sonatype.nexus.util.io.StreamSupport;

public class StorageFileItemRepresentation
extends StorageItemRepresentation {
    private static final int OUTPUT_BUFFER_SIZE = SystemPropertiesHelper.getInteger((String)"org.sonatype.nexus.rest.StorageFileItemRepresentation.outputBufferSize", (int)4096);

    public StorageFileItemRepresentation(StorageFileItem file) {
        super(MediaType.valueOf((String)file.getMimeType()), (StorageItem)file);
        this.setSize(file.getLength());
        if (file.getRepositoryItemAttributes().containsKey(DigestCalculatingInspector.DIGEST_SHA1_KEY)) {
            String tag = String.format("{SHA1{%s}}", file.getRepositoryItemAttributes().get(DigestCalculatingInspector.DIGEST_SHA1_KEY));
            this.setTag(new Tag(tag, false));
        }
        if (file.getItemContext().containsKey((Object)"override-filename")) {
            String filename = file.getItemContext().get((Object)"override-filename").toString();
            this.setDownloadable(true);
            this.setDownloadName(filename);
        }
    }

    protected StorageFileItem getStorageItem() {
        return (StorageFileItem)super.getStorageItem();
    }

    public boolean isTransient() {
        return !this.getStorageItem().isReusableStream();
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        block14: {
            try (InputStream is = this.getStorageItem().getInputStream();){
                StreamSupport.copy((InputStream)is, (OutputStream)outputStream, (int)OUTPUT_BUFFER_SIZE);
            }
            catch (IOException e) {
                if ("EofException".equals(e.getClass().getSimpleName()) || e instanceof SocketException) break block14;
                throw e;
            }
        }
    }
}

