/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rest;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.restlet.data.Request;
import org.sonatype.nexus.configuration.application.GlobalRestApiSettings;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.registry.RepositoryTypeDescriptor;
import org.sonatype.nexus.proxy.registry.RepositoryTypeRegistry;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.nexus.proxy.utils.RepositoryStringUtils;
import org.sonatype.nexus.rest.RepositoryURLBuilder;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class RestletRepositoryURLBuilder
extends ComponentSupport
implements RepositoryURLBuilder {
    private final RepositoryRegistry repositoryRegistry;
    private final RepositoryTypeRegistry repositoryTypeRegistry;
    private final GlobalRestApiSettings globalRestApiSettings;

    @Inject
    public RestletRepositoryURLBuilder(RepositoryRegistry repositoryRegistry, RepositoryTypeRegistry repositoryTypeRegistry, GlobalRestApiSettings globalRestApiSettings) {
        this.repositoryRegistry = repositoryRegistry;
        this.repositoryTypeRegistry = repositoryTypeRegistry;
        this.globalRestApiSettings = globalRestApiSettings;
    }

    @Override
    public String getRepositoryContentUrl(String repositoryId) throws NoSuchRepositoryException {
        return this.getRepositoryContentUrl(repositoryId, false);
    }

    @Override
    public String getRepositoryContentUrl(String repositoryId, boolean forceBaseURL) throws NoSuchRepositoryException {
        return this.getRepositoryContentUrl(this.repositoryRegistry.getRepository(repositoryId), forceBaseURL);
    }

    @Override
    public String getRepositoryContentUrl(Repository repository) {
        return this.getRepositoryContentUrl(repository, false);
    }

    @Override
    public String getRepositoryContentUrl(Repository repository, boolean forceBaseURL) {
        boolean shouldForceBaseUrl;
        boolean bl = shouldForceBaseUrl = forceBaseURL || this.globalRestApiSettings.isEnabled() && this.globalRestApiSettings.isForceBaseUrl() && StringUtils.isNotBlank((String)this.globalRestApiSettings.getBaseUrl());
        String baseURL = shouldForceBaseUrl ? (this.globalRestApiSettings.isEnabled() ? this.globalRestApiSettings.getBaseUrl() : null) : (Request.getCurrent() != null ? Request.getCurrent().getRootRef().getParentRef().getParentRef().toString() : this.globalRestApiSettings.getBaseUrl());
        if (StringUtils.isBlank((String)baseURL)) {
            this.log.info("Not able to build content URL of the repository {}, baseUrl not set!", (Object)RepositoryStringUtils.getHumanizedNameString((Repository)repository));
            return null;
        }
        StringBuilder url = new StringBuilder(baseURL);
        if (!baseURL.endsWith("/")) {
            url.append("/");
        }
        RepositoryTypeDescriptor rtd = this.repositoryTypeRegistry.getRepositoryTypeDescriptor(repository.getProviderRole(), repository.getProviderHint());
        url.append("content/").append(rtd.getPrefix()).append("/").append(repository.getPathPrefix());
        return url.toString();
    }

    @Override
    public String getExposedRepositoryContentUrl(Repository repository) {
        return this.getExposedRepositoryContentUrl(repository, false);
    }

    @Override
    public String getExposedRepositoryContentUrl(Repository repository, boolean forceBaseURL) {
        if (!repository.isExposed()) {
            return null;
        }
        return this.getRepositoryContentUrl(repository, forceBaseURL);
    }
}

